// $Id: chat.c,v 1.7 2003/06/29 05:52:56 lemit Exp $
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "db.h"
#include "map.h"
#include "clif.h"
#include "pc.h"
#include "chat.h"

#ifdef MEMWATCH
#include "memwatch.h"
#endif

/*==========================================
 * åȥ롼
 *------------------------------------------
 */
int chat_createchat(struct map_session_data *sd,int limit,int pub,char* pass,char* title,int titlelen)
{
	struct chat_data *cd;

	cd = malloc(sizeof(*cd));
	if(cd==NULL){
		printf("out of memory : chat_createchat\n");
		exit(1);
	}
	memset(cd,0,sizeof(*cd));

	cd->limit = limit;
	cd->pub = pub;
	cd->users = 1;
	memcpy(cd->pass,pass,8);
	if(titlelen>=sizeof(cd->title)-1) titlelen=sizeof(cd->title)-1;
	memcpy(cd->title,title,titlelen);
	cd->title[titlelen]=0;

	cd->usersd[0] = sd;
	cd->bl.m = sd->bl.m;
	cd->bl.x = sd->bl.x;
	cd->bl.y = sd->bl.y;
	cd->bl.type = BL_CHAT;

	cd->bl.id = map_addobject(&cd->bl);	
	if(cd->bl.id==0){
		clif_createchat(sd,1);
		free(cd);
		return 0;
	}
	pc_setchatid(sd,cd->bl.id);

	clif_createchat(sd,0);
	clif_dispchat(cd,0);

	return 0;
}

/*==========================================
 * ¸åȥ롼˻
 *------------------------------------------
 */
int chat_joinchat(struct map_session_data *sd,int chatid,char* pass)
{
	struct chat_data *cd;

	cd=(struct chat_data*)map_id2bl(chatid);
	if(cd==NULL)
		return 1;

	if(cd->bl.m != sd->bl.m || cd->limit == cd->users){
		clif_joinchatfail(sd,0);
		return 0;
	}
	if(cd->pub==0 && strncmp(pass,cd->pass,8)){
		clif_joinchatfail(sd,1);
		return 0;
	}

	cd->usersd[cd->users] = sd;
	cd->users++;

	pc_setchatid(sd,cd->bl.id);

	// ˻äͤˤΥꥹ
	clif_joinchatok(sd,cd);

	// ˵錄ͤˤɲäͤ
	clif_addchat(cd,sd);

	// ϤοͤˤϿͿѲ
	clif_dispchat(cd,0);

	return 0;
}

/*==========================================
 * åȥ롼फȴ
 *------------------------------------------
 */
int chat_leavechat(struct map_session_data *sd)
{
	struct chat_data *cd;
	int i,leavechar;

	cd=(struct chat_data*)map_id2bl(sd->chatID);
	if(cd==NULL)
		return 1;

	for(i = 0,leavechar=-1;i < cd->users;i++){
		if(cd->usersd[i] == sd){
			leavechar=i;
			break;
		}
	}
	if(leavechar<0)	// chat˽°Ƥʤ餷 (ХΤ)
		return -1;

	if(leavechar==0 && cd->users>1){	// ͭԤä&¾˿ͤ
		clif_changechatowner(cd,cd->usersd[1]);
		clif_clearchat(cd,0);
	}

	// ȴPCˤΤusers򸺤餹˼¹
	clif_leavechat(cd,sd);

	cd->users--;
	pc_setchatid(sd,0);

	if(cd->users == 0){		// ʤʤäΤǾä
		clif_clearchat(cd,0);
		map_delobject(cd->bl.id);	// freeޤǤƤ
	} else {
		for(i=leavechar;i < cd->users;i++)
			cd->usersd[i] = cd->usersd[i+1];
		if(leavechar==0){	// ͭԤȴΤǰѹ
			cd->bl.x=cd->usersd[0]->bl.x;
			cd->bl.y=cd->usersd[0]->bl.y;
		}
		clif_dispchat(cd,0);
	}

	return 0;
}

/*==========================================
 * åȥ롼λ
 *------------------------------------------
 */
int chat_changechatowner(struct map_session_data *sd,char *nextownername)
{
	struct chat_data *cd;
	struct map_session_data *tmp_sd;
	int i,nextowner;

	cd=(struct chat_data*)map_id2bl(sd->chatID);
	if(cd==NULL || sd!=cd->usersd[0])
		return 1;

	for(i = 1,nextowner=-1;i < cd->users;i++){
		if(strcmp(cd->usersd[i]->status.name,nextownername)==0){
			nextowner=i;
			break;
		}
	}
	if(nextowner<0) // ʿͤϵʤ
		return -1;

	clif_changechatowner(cd,cd->usersd[nextowner]);
	// öä
	clif_clearchat(cd,0);

	// userlistνѹ (0ͭԤʤΤ)
	tmp_sd = cd->usersd[0];
	cd->usersd[0] = cd->usersd[nextowner];
	cd->usersd[nextowner] = tmp_sd;

	// ͭԤΰ֤ѹ
	cd->bl.x=cd->usersd[0]->bl.x;
	cd->bl.y=cd->usersd[0]->bl.y;

	// ɽ
	clif_dispchat(cd,0);

	return 0;
}

/*==========================================
 * åȤξ(ȥ)ѹ
 *------------------------------------------
 */
int chat_changechatstatus(struct map_session_data *sd,int limit,int pub,char* pass,char* title,int titlelen)
{
	struct chat_data *cd;

	cd=(struct chat_data*)map_id2bl(sd->chatID);
	if(cd==NULL || sd!=cd->usersd[0])
		return 1;

	cd->limit = limit;
	cd->pub = pub;
	memcpy(cd->pass,pass,8);
	if(titlelen>=sizeof(cd->title)-1) titlelen=sizeof(cd->title)-1;
	memcpy(cd->title,title,titlelen);
	cd->title[titlelen]=0;

	clif_changechatstatus(cd);
	clif_dispchat(cd,0);

	return 0;
}

/*==========================================
 * åȥ롼फ齳Ф
 *------------------------------------------
 */
int chat_kickchat(struct map_session_data *sd,char *kickusername)
{
	struct chat_data *cd;
	int i,kickuser;

	cd=(struct chat_data*)map_id2bl(sd->chatID);
	if(cd==NULL || sd!=cd->usersd[0])
		return 1;

	for(i = 0,kickuser=-1;i < cd->users;i++){
		if(strcmp(cd->usersd[i]->status.name,kickusername)==0){
			kickuser=i;
			break;
		}
	}
	if(kickuser<0) // ʿͤϵʤ
		return -1;

	chat_leavechat(cd->usersd[kickuser]);

	return 0;
}
