#ifndef _CLIF_H_
#define _CLIF_H_

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include "map.h"

void clif_setip(char*);
void clif_setport(int);

in_addr_t clif_getip(void);
int clif_getport(void);
int clif_countusers(void);
void clif_setwaitclose(int);

int clif_authok(struct map_session_data *);
int clif_authfail_fd(int,int);
int clif_charselectok(int);
int clif_dropflooritem(struct flooritem_data *);
int clif_clearflooritem(struct flooritem_data *,int);
int clif_clearchar(struct block_list*,int);	// area or fd
#define clif_clearchar_area(sd,type) clif_clearchar(sd,type)
int clif_clearchar_id(int,int,int);
int clif_spawnpc(struct map_session_data*);	//area
int clif_spawnnpc(struct npc_data*);	// area
int clif_spawnmob(struct mob_data*);	// area
int clif_walkok(struct map_session_data*);	// self
int clif_movechar(struct map_session_data*);	// area
int clif_movemob(struct mob_data*);	//area
int clif_changemap(struct map_session_data*,char*,int,int);	//self
int clif_changemapserver(struct map_session_data*,char*,int,int,int,int);	//self
int clif_fixpos(struct block_list *);	// area
int clif_npcbuysell(struct map_session_data*,int);	//self
int clif_buylist(struct map_session_data*,struct npc_data*);	//self
int clif_selllist(struct map_session_data*);	//self
int clif_scriptmes(struct map_session_data*,int,char*);	//self
int clif_scriptnext(struct map_session_data*,int);	//self
int clif_scriptclose(struct map_session_data*,int);	//self
int clif_scriptmenu(struct map_session_data*,int,char*);	//self
int clif_scriptinput(struct map_session_data*,int);	//self
int clif_cutin(struct map_session_data*,char*,int);	//self
int clif_viewpoint(struct map_session_data*,int,int,int,int,int,int);	//self
int clif_additem(struct map_session_data*,int,int,int);	//self
int clif_delitem(struct map_session_data*,int,int);	//self
int clif_updatestatus(struct map_session_data*,int);	//self
int clif_damage(struct block_list *,struct block_list *,unsigned int,int,int,int,int,int,int);	// area
#define clif_takeitem(src,dst) clif_damage(src,dst,0,0,0,0,0,1,0)
int clif_changelook(struct block_list *,int,int);	// area
int clif_statusupack(struct map_session_data *,int,int,int);	// self
int clif_equipitemack(struct map_session_data *,int,int,int);	// self
int clif_unequipitemack(struct map_session_data *,int,int,int);	// self
int clif_misceffect(struct block_list*,int);	// area
int clif_changeoption(struct map_session_data*);	// area
int clif_useitemack(struct map_session_data*,int,int,int);	// self

int clif_createchat(struct map_session_data*,int);	// self
int clif_dispchat(struct chat_data*,int);	// area or fd
int clif_joinchatfail(struct map_session_data*,int);	// self
int clif_joinchatok(struct map_session_data*,struct chat_data*);	// self
int clif_addchat(struct chat_data*,struct map_session_data*);	// chat
int clif_changechatowner(struct chat_data*,struct map_session_data*);	// chat
int clif_clearchat(struct chat_data*,int);	// area or fd
int clif_leavechat(struct chat_data*,struct map_session_data*);	// chat
int clif_changechatstatus(struct chat_data*);	// chat

int clif_pcinsight(struct block_list *,va_list);	// map_forallinmovearea callback
int clif_pcoutsight(struct block_list *,va_list);	// map_forallinmovearea callback
int clif_mobinsight(struct block_list *,va_list);	// map_forallinmovearea callback
int clif_moboutsight(struct block_list *,va_list);	// map_forallinmovearea callback

int clif_foreachclient(int (*)(struct map_session_data*,va_list),...);

int do_init_clif(void);

#endif

