// $Id: pc.c,v 1.26 2003/07/04 15:26:33 lemit Exp $
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "timer.h"
#include "map.h"
#include "clif.h"
#include "pc.h"
#include "npc.h"
#include "mob.h"
#include "itemdb.h"
#include "script.h"

#ifdef MEMWATCH
#include "memwatch.h"
#endif

static int max_weight_base[21];
static int hp_coefficient[21];
static int sp_coefficient[21];
static int aspd_base[21][20];
static char job_bonus[21][50];
static int exp_table[4][100];
static struct {
	int id;
	int max;
	struct {
		short id,lv;
	} need[6];
} skill_tree[MAX_PC_CLASS][64];

// atk db/ذưͽ
static int atkmods[3][20]={
	{100,100, 75, 75, 75, 75, 50, 50, 75,100,100,100,100,100,100,100, 75},
	{100, 75,100, 75, 75, 75, 75, 75,100,100,100,100,100,100,100,100,100},
	{100, 50, 75,100,100,100,100,100,100,100,100, 75,100,100,100, 75, 75}
};

/*==========================================
 * ץȥ (ɬפʪΤ)
 *------------------------------------------
 */
static int pc_walktoxy_sub(struct map_session_data *);

/*==========================================
 * saveɬפʥơԤʤ
 *------------------------------------------
 */
int pc_makesavestatus(struct map_session_data *sd)
{
	// οϿ¿Τ¸оݤˤϤʤ
	sd->status.clothes_color=0;

	// ˴֤äΤhp1֤򥻡־ѹ
	if(pc_isdead(sd)){
		sd->status.hp=1;

		memcpy(&sd->status.last_point,&sd->status.save_point,sizeof(sd->status.last_point));
	} else {
		memcpy(sd->status.last_point.map,sd->mapname,16);
		sd->status.last_point.x = sd->bl.x;
		sd->status.last_point.y = sd->bl.y;
	}
	return 0;
}

/*==========================================
 * ³ν
 *------------------------------------------
 */
int pc_setnewpc(struct map_session_data *sd,int account_id,int char_id,int login_id1,int client_tick,int sex,int fd)
{
	sd->bl.id        = account_id;
	sd->char_id      = char_id;
	sd->login_id1    = login_id1;
	sd->client_tick  = client_tick;
	sd->sex          = sex;
	sd->state.auth   = 0;
	sd->bl.type      = BL_PC;
	sd->canmove_tick = gettick();

	return 0;
}

/*==========================================
 * session id̵
 * charƤơ
 *------------------------------------------
 */
int pc_authok(int id,struct mmo_charstatus *st)
{
	struct map_session_data *sd;

	sd = map_id2sd(id);
	if(sd==NULL)
		return 1;
	if(sd->new_fd){
		// 2login֤äΤǡξ
		clif_authfail_fd(sd->fd,2);	// same id
		clif_authfail_fd(sd->new_fd,2);	// same id
		return 1;
	}
	memcpy(&sd->status,st,sizeof(*st));

	if(sd->status.sex != sd->sex){
		clif_authfail_fd(sd->fd,0);
		return 1;
	}
	pc_setpos(sd,sd->status.last_point.map , sd->status.last_point.x , sd->status.last_point.y, 0);

	sd->speed = DEFAULT_WALK_SPEED;
	sd->dead_sit=0;
	sd->dir=0;
	sd->head_dir=0;
	sd->state.auth=1;
	sd->walktimer=-1;
	sd->attacktimer=-1;
	sd->skilltimer=-1;

	clif_authok(sd);
	map_addnickdb(sd);

	pc_calcstatus(sd,1);

	return 0;
}

/*==========================================
 * session idꤢʤΤǸ
 *------------------------------------------
 */
int pc_authfail(int id)
{
	struct map_session_data *sd;

	sd = map_id2sd(id);
	if(sd==NULL)
		return 1;
	if(sd->new_fd){
		// 2login֤äΤǡ³Τ
		clif_authfail_fd(sd->new_fd,0);

		sd->new_fd=0;
		return 0;
	}
	clif_authfail_fd(sd->fd,0);
	return 0;
}

/*==========================================
 * ѥ᡼׻
 * first==0λ׻оݤΥѥ᡼ƤӽФ
 * Ѳ缫ưsend뤬
 * ǽưŪѲѥ᡼ϼsend褦
 *------------------------------------------
 */
int pc_calcstatus(struct map_session_data* sd,int first)
{
	int i,bl;
	struct map_session_data before;
	int weapontype;

	memcpy(&before,sd,sizeof(before));

	sd->max_weight=max_weight_base[sd->status.class]+sd->status.str*300;

	sd->weight=0;
	for(i=0;i<MAX_INVENTORY;i++){
		if(sd->status.inventory[i].nameid==0)
			continue;
		sd->weight+=itemdb_weight(sd->status.inventory[i].nameid)*sd->status.inventory[i].amount;
	}

	for(i=0;i<6;i++)
		sd->paramb[i]=0;
	sd->hit = 0;
	sd->flee = 0;
	sd->aspd = 0;
	sd->watk = 0;
	sd->def = 0;
	sd->mdef = 0;
	sd->status.max_hp = 0;
	sd->status.max_sp = 0;
	sd->status.weapon = 0;
	sd->status.sheild = 0;
	sd->status.head_top = 0;
	sd->status.head_mid = 0;
	sd->status.head_bottom = 0;
	sd->attackrange = 1;
	weapontype = 0;

	// ʤˤ륹ơѲϤǼ¹
	for(i=0;i<MAX_INVENTORY;i++){
		int nameid=sd->status.inventory[i].nameid,ep;

		if(nameid==0 || (ep=sd->status.inventory[i].equip)==0)
			continue;
		if(itemdb_type(nameid)==4){	//  2ήϹθ
			sd->status.weapon = weapontype = itemdb_look(nameid);
			sd->attackrange = itemdb_range(nameid);
		} else if(itemdb_type(nameid)==5){ // ɶ
			if(ep&0x1)
				sd->status.head_bottom = itemdb_look(nameid);
			else if(ep&0x20)
				sd->status.sheild = itemdb_look(nameid);
			else if(ep&0x100)
				sd->status.head_top = itemdb_look(nameid);
			else if(ep&0x200)
				sd->status.head_mid = itemdb_look(nameid);
		}
		sd->watk += itemdb_atk(nameid);
		sd->def += itemdb_def(nameid);
		run_script(itemdb_equipscript(nameid),0,sd->bl.id,0);
	}
	sd->atkmods[0] = atkmods[0][weapontype];
	sd->atkmods[1] = atkmods[1][weapontype];
	sd->atkmods[2] = atkmods[2][weapontype];

	// jobܡʥʬ
	for(i=0;i<sd->status.job_level && i<50;i++)
		if(job_bonus[sd->status.class][i])
			sd->paramb[job_bonus[sd->status.class][i]-1]++;

	sd->paramc[0]=sd->status.str+sd->paramb[0];
	sd->paramc[1]=sd->status.agi+sd->paramb[1];
	sd->paramc[2]=sd->status.vit+sd->paramb[2];
	sd->paramc[3]=sd->status.int_+sd->paramb[3];
	sd->paramc[4]=sd->status.dex+sd->paramb[4];
	sd->paramc[5]=sd->status.luk+sd->paramb[5];

	sd->hit += sd->paramc[4] + sd->status.base_level;
	sd->flee += sd->paramc[1] + sd->status.base_level;
	sd->aspd += 10 * aspd_base[sd->status.class][weapontype] * (250 - sd->paramc[1] - sd->paramc[4]/4) /250;
	if(sd->aspd < 200) sd->aspd = 200;
	sd->amotion = sd->aspd;
	sd->dmotion = 800-sd->paramc[1]*4;
	if(sd->dmotion<400)
		sd->dmotion = 400;

	bl=sd->status.base_level;
	sd->status.max_hp += (35 + bl * 5 + ((1 + bl) * bl / 2) * hp_coefficient[sd->status.class] / 100) * (100 + sd->paramc[2]) / 100;
	sd->status.max_sp += sp_coefficient[sd->status.class] * bl * (100+sd->paramc[3]) / 100 ;
	if(sd->status.hp>sd->status.max_hp)
		sd->status.hp=sd->status.max_hp;
	if(sd->status.sp>sd->status.max_sp)
		sd->status.sp=sd->status.max_sp;

	if(first)
		return 0;

	if(before.weight != sd->weight)
		clif_updatestatus(sd,SP_WEIGHT);
	if(before.max_weight != sd->max_weight)
		clif_updatestatus(sd,SP_MAXWEIGHT);
	for(i=0;i<6;i++)
		if(before.paramb[i] != sd->paramb[i])
			clif_updatestatus(sd,SP_STR+i);
	if(before.hit != sd->hit)
		clif_updatestatus(sd,SP_HIT);
	if(before.flee != sd->flee)
		clif_updatestatus(sd,SP_FLEE1);
	if(before.aspd != sd->aspd)
		clif_updatestatus(sd,SP_ASPD);
	if(before.watk != sd->watk)
		clif_updatestatus(sd,SP_ATK1);
	if(before.def != sd->def)
		clif_updatestatus(sd,SP_DEF1);

	if(before.status.max_hp != sd->status.max_hp)
		clif_updatestatus(sd,SP_MAXHP);
	if(before.status.max_sp != sd->status.max_sp)
		clif_updatestatus(sd,SP_MAXSP);
	if(before.status.hp != sd->status.hp)
		clif_updatestatus(sd,SP_HP);
	if(before.status.sp != sd->status.sp)
		clif_updatestatus(sd,SP_SP);

	// ʤˤ븫ܤѲʬ
	if(before.status.weapon != sd->status.weapon)
		clif_changelook(&sd->bl,LOOK_WEAPON,sd->status.weapon);
	if(before.status.sheild != sd->status.sheild)
		clif_changelook(&sd->bl,LOOK_SHEILD,sd->status.sheild);
	if(before.status.head_bottom != sd->status.head_bottom)
		clif_changelook(&sd->bl,LOOK_HEAD_BOTTOM,sd->status.head_bottom);
	if(before.status.head_top != sd->status.head_top)
		clif_changelook(&sd->bl,LOOK_HEAD_TOP,sd->status.head_top);
	if(before.status.head_mid != sd->status.head_mid)
		clif_changelook(&sd->bl,LOOK_HEAD_MID,sd->status.head_mid);

	return 0;
}

/*==========================================
 * ʤˤǽΥܡʥ
 *------------------------------------------
 */
int pc_bonus(struct map_session_data *sd,int type,int val)
{
	switch(type){
	}
	return 0;
}

//
// ƥʪ
//
/*==========================================
 * ˤ㤤ͽ
 *------------------------------------------
 */
int pc_modifybuyvalue(struct map_session_data *sd,int orig_value)
{
	return orig_value;
}

/*==========================================
 * ˤͽ
 *------------------------------------------
 */
int pc_modifysellvalue(struct map_session_data *sd,int orig_value)
{
	return orig_value;
}

/*==========================================
 * ƥäˡƥȤ
 * 3¤ˤ뤫ǧ
 *------------------------------------------
 */
int pc_checkadditem(struct map_session_data *sd,int nameid,int amount)
{
	int i;

	if(itemdb_isequip(nameid))
		return ADDITEM_NEW;

	for(i=0;i<MAX_INVENTORY;i++){
		if(sd->status.inventory[i].nameid==nameid){
			if(sd->status.inventory[i].amount+amount > MAX_AMOUNT)
				return ADDITEM_OVERAMOUNT;
			return ADDITEM_EXIST;
		}
	}
	return ADDITEM_NEW;
}

/*==========================================
 * ƥθĿ
 *------------------------------------------
 */
int pc_inventoryblank(struct map_session_data *sd)
{
	int i,b;
	for(i=0,b=0;i<MAX_INVENTORY;i++){
		if(sd->status.inventory[i].nameid==0)
			b++;
	}
	return b;
}

/*==========================================
 * ʧ
 *------------------------------------------
 */
int pc_payzeny(struct map_session_data *sd,int zeny)
{
	if(sd->status.zeny<zeny)
		return 1;
	sd->status.zeny-=zeny;
	clif_updatestatus(sd,SP_ZENY);
	return 0;
}

/*==========================================
 * 
 *------------------------------------------
 */
int pc_getzeny(struct map_session_data *sd,int zeny)
{
	if(sd->status.zeny+zeny > MAX_ZENY)
		return 1;
	sd->status.zeny+=zeny;
	clif_updatestatus(sd,SP_ZENY);
	return 0;
}

/*==========================================
 * ƥɲáĿΤitem¤Το̵
 *------------------------------------------
 */
int pc_additem(struct map_session_data *sd,struct item *item_data,int amount)
{
	int i;

	if(itemdb_weight(item_data->nameid)*amount + sd->weight > sd->max_weight)
		return 1;

	i=MAX_INVENTORY;
	if(!itemdb_isequip(item_data->nameid)){
		// ʤǤϤʤΤǡͭʤʤĿΤѲ
		for(i=0;i<MAX_INVENTORY;i++){
			if(sd->status.inventory[i].nameid==item_data->nameid){
				if(sd->status.inventory[i].amount+amount > MAX_AMOUNT)
					return 1;
				sd->status.inventory[i].amount+=amount;
				clif_additem(sd,i,amount,0);
				break;
			}
		}
	}
	if(i==MAX_INVENTORY){
		// ʤ̤ͭʤäΤǶɲ
		for(i=MAX_INVENTORY-1;i>=0;i--){
			if(sd->status.inventory[i].nameid==0 &&
			   (i==0 || sd->status.inventory[i-1].nameid)){
				memcpy(&sd->status.inventory[i],item_data,sizeof(sd->status.inventory[0]));
				sd->status.inventory[i].amount=amount;
				clif_additem(sd,i,amount,0);
				break;
			}
		}
		if(i<0)
			return 1;
	}
	sd->weight += itemdb_weight(item_data->nameid)*amount ;
	clif_updatestatus(sd,SP_WEIGHT);

	return 0;
}

/*==========================================
 * ƥ򸺤餹
 *------------------------------------------
 */
int pc_delitem(struct map_session_data *sd,int n,int amount)
{
	if(sd->status.inventory[n].nameid==0 ||
	   sd->status.inventory[n].amount<amount)
		return 1;

	sd->status.inventory[n].amount-=amount;
	sd->weight -= itemdb_weight(sd->status.inventory[n].nameid)*amount ;
	if(sd->status.inventory[n].amount==0){
		memset(&sd->status.inventory[n],0,sizeof(sd->status.inventory[0]));
	}
	clif_delitem(sd,n,amount);
	clif_updatestatus(sd,SP_WEIGHT);

	return 0;
}

/*==========================================
 * ƥ
 *------------------------------------------
 */
int pc_dropitem(struct map_session_data *sd,int n,int amount)
{
	if(sd->status.inventory[n].nameid==0 ||
	   sd->status.inventory[n].amount<amount)
		return 1;
	map_addflooritem(&sd->status.inventory[n],amount,sd->bl.m,sd->bl.x,sd->bl.y);
	pc_delitem(sd,n,amount);
	return 0;
}

/*==========================================
 * ƥ򽦤
 *------------------------------------------
 */
int pc_takeitem(struct map_session_data *sd,struct flooritem_data *fitem)
{
	if(pc_additem(sd,&fitem->item_data,fitem->item_data.amount)){
		// overǼ
		clif_additem(sd,0,0,2);
	} else {
		// 
		clif_takeitem(&sd->bl,&fitem->bl);
		map_clearflooritem(fitem->bl.id);
	}
	return 0;
}

/*==========================================
 * ƥȤ
 *------------------------------------------
 */
int pc_useitem(struct map_session_data *sd,int n)
{
	int nameid,amount;

	if(sd->status.inventory[n].nameid==0 ||
	   sd->status.inventory[n].amount<1){
		clif_useitemack(sd,n,0,0);
		return 1;
	}

	nameid = sd->status.inventory[n].nameid;
	amount = sd->status.inventory[n].amount;

	sd->status.inventory[n].amount--;
	sd->weight -= itemdb_weight(nameid) ;
	if(sd->status.inventory[n].amount==0){
		memset(&sd->status.inventory[n],0,sizeof(sd->status.inventory[0]));
	}

	run_script(itemdb_usescript(nameid),0,sd->bl.id,0);

	clif_useitemack(sd,n,amount-1,1);
	clif_updatestatus(sd,SP_WEIGHT);

	return 0;
}


//
//
//
/*==========================================
 * PCΰ
 *------------------------------------------
 */
int pc_setpos(struct map_session_data *sd,char *mapname_org,int x,int y,int clrtype)
{
	char mapname[24];
	int m,c;

	memcpy(mapname,mapname_org,16);
	mapname[16]=0;
	m=map_mapname2mapid(mapname);
	if(m<0){
		strcat(mapname,".gat");
		m=map_mapname2mapid(mapname);
	}
	if(m<0){
		if(sd->mapname[0]){
			int ip,port;
			if(map_mapname2ipport(mapname,&ip,&port)==0){
				clif_changemapserver(sd,mapname,x,y,ip,port);
				return 0;
			}
		}
#if 0
		clif_authfail_fd(sd->fd,0);	// cansel
		clif_setwaitclose(sd->fd);
#endif
		return 1;
	}

	if(x <0 || x >= map[m].xs || y <0 || y >= map[m].ys)
		x=y=0;
	if((x==0 && y==0) || (c=read_gat(m,x,y))==1 || c==5){
		if(x||y) printf("stacked (%d,%d)\n",x,y);
		do {
			x=rand()%(map[m].xs-2)+1;
			y=rand()%(map[m].ys-2)+1;
		} while((c=read_gat(m,x,y))==1 || c==5);
	}

	if(sd->mapname[0]){
		clif_clearchar_area(&sd->bl,clrtype); printf("pc.c 63 clif_clearchar_area\n");
		map_delblock(&sd->bl);
		clif_changemap(sd,mapname,x,y);
	}

	memcpy(sd->mapname,mapname,16);
	sd->bl.m = m;
	sd->bl.x = x;
	sd->bl.y = y;

	sd->walkpath.path_half=0;
	sd->walkpath.path_len=0;
	sd->walkpath.path_pos=0;

	map_addblock(&sd->bl);
	clif_spawnpc(sd);

	return 0;
}

//
// ʪ
//
/*==========================================
 * 1ˤ֤׻
 *------------------------------------------
 */
static int calc_next_walk_step(struct map_session_data *sd)
{
	if(sd->walkpath.path_pos>=sd->walkpath.path_len)
		return -1;
	if(sd->walkpath.path[sd->walkpath.path_pos]&1)
		return sd->speed*14/10;
	return sd->speed;
}

/*==========================================
 * Ⱦʤ(timerؿ)
 *------------------------------------------
 */
static int pc_walk(int tid,unsigned int tick,int id,int data)
{
	struct map_session_data *sd;
	int i;
	static int dirx[8]={0,-1,-1,-1,0,1,1,1};
	static int diry[8]={1,1,0,-1,-1,-1,0,1};
	int x,y,dx,dy;

	sd=map_id2sd(id);
	if(sd==NULL)
		return 0;

	if(sd->walktimer != tid){
		printf("pc_walk %d != %d\n",sd->walktimer,tid);
		return 0;
	}
	sd->walktimer=-1;
	if(sd->walkpath.path_pos>=sd->walkpath.path_len || sd->walkpath.path_pos!=data)
		return 0;

	sd->walkpath.path_half ^= 1;
	if(sd->walkpath.path_half==0){ // ޥ濴
		sd->walkpath.path_pos++;
		if(sd->state.change_walk_target){
			pc_walktoxy_sub(sd);
			return 0;
		}
	} else { // ޥܶ
		int moveblock;

		if(sd->walkpath.path[sd->walkpath.path_pos]>=8)
			return 1;

		x = sd->bl.x;
		y = sd->bl.y;
		dx = dirx[sd->walkpath.path[sd->walkpath.path_pos]];
		dy = diry[sd->walkpath.path[sd->walkpath.path_pos]];
		moveblock = ( x/BLOCK_SIZE != (x+dx)/BLOCK_SIZE || y/BLOCK_SIZE != (y+dy)/BLOCK_SIZE);

		map_foreachinmovearea(clif_pcoutsight,sd->bl.m,x-AREA_SIZE,y-AREA_SIZE,x+AREA_SIZE,y+AREA_SIZE,dx,dy,0,sd);

		x += dx;
		y += dy;

		if(moveblock) map_delblock(&sd->bl);
		sd->bl.x = x;
		sd->bl.y = y;
		if(moveblock) map_addblock(&sd->bl);

		map_foreachinmovearea(clif_pcinsight,sd->bl.m,x-AREA_SIZE,y-AREA_SIZE,x+AREA_SIZE,y+AREA_SIZE,-dx,-dy,0,sd);

		if(map_getcell(sd->bl.m,x,y)&0x80)
			npc_touch_areanpc(sd,sd->bl.m,x,y);
	}
	if((i=calc_next_walk_step(sd))>0)
		sd->walktimer=add_timer(tick+i/2,pc_walk,id,sd->walkpath.path_pos);

	return 0;
}

/*==========================================
 * ưǽǧơǽʤԳ
 *------------------------------------------
 */
static int pc_walktoxy_sub(struct map_session_data *sd)
{
	struct walkpath_data wpd;
	int i;

	if(path_search(&wpd,sd->bl.m,sd->bl.x,sd->bl.y,sd->to_x,sd->to_y,0))
		return 1;
	memcpy(&sd->walkpath,&wpd,sizeof(wpd));

	clif_walkok(sd);
	clif_movechar(sd);

	sd->state.change_walk_target=0;

	if((i=calc_next_walk_step(sd))>0){
		sd->walktimer=add_timer(gettick()+i/4,pc_walk,sd->bl.id,0);
	}

	return 0;
}

/*==========================================
 * pc׵
 *------------------------------------------
 */
int pc_walktoxy(struct map_session_data *sd,int x,int y)
{
	sd->to_x=x;
	sd->to_y=y;

	if(sd->walktimer>0 && sd->state.change_walk_target==0){
		// ⤤ƤŪѹʤΤǥޥܤ濴褿
		// timerؿpc_walktoxy_subƤ֤褦ˤ
		sd->state.change_walk_target=1;
	} else {
		pc_walktoxy_sub(sd);
	}

	return 0;
}

/*==========================================
 * 
 *------------------------------------------
 */
int pc_stop_walking(struct map_session_data *sd)
{
	if(sd->walktimer>0){
		delete_timer(sd->walktimer,pc_walk);
		sd->walktimer=-1;
		clif_fixpos(&sd->bl);
	}
	return 0;
}

//
// Ʈ
//
/*==========================================
 * θ ͭƤLv֤
 *------------------------------------------
 */
int pc_checkskill(struct map_session_data *sd,int skill_id)
{
	int i;
	for(i = 0;i < MAX_SKILL;i++) {
		if(sd->status.skill[i].id == skill_id) return (sd->status.skill[i].lv);
	}
	return -1;

}

/*==========================================
 * ʤΥå
 *------------------------------------------
 */
int pc_checkequip(struct map_session_data *sd,int pos)
{
	int i;
	for(i=0;i<MAX_INVENTORY;i++){
		if(sd->status.inventory[i].nameid &&
		   (sd->status.inventory[i].equip&pos)){
			return (sd->status.inventory[i].nameid);
		}
	}
	return (-1);
}

/*==========================================
 * ᡼
 *------------------------------------------
 */
int pc_addmastery(struct map_session_data *sd,struct mob_data *md,int dmg)
{
	int damage,skill,item_id;
	damage = 0;
#if 0
	// ǡ٥(+3  +30) vs Ի or  (ͤϴޤʤ)
	if((skill = pc_checkskill(sd,23)) != -1) {
		damage += (skill * 3);
	}
#endif
	item_id = pc_checkequip(sd,2);	// orξ
	if(item_id == -1) return (dmg);
	switch(itemdb_look(item_id))
	{
		case 0x01:	// û
		case 0x02:	// Ҽ
		{
			// (+4  +40) Ҽ ûޤ
			if((skill = pc_checkskill(sd,2)) != -1) {
				damage += (skill * 4);
			}
			break;
		}
		case 0x03:	// ξ
		{
			// ξ(+4  +40) ξ
			if((skill = pc_checkskill(sd,3)) != -1) {
				damage += (skill * 4);
			}
			break;
		}
		case 0x04:	// Ҽ
		case 0x05:	// ξ
		{
			// 佤(+4  +40,+5  +50) 
			if((skill = pc_checkskill(sd,55)) != -1) {
				damage += (skill * 4);	// ڥ˾äƤʤ
				// damage += (skill * 5);	// ڥ˾äƤ
			}
			break;
		}
		case 0x06:	// Ҽ
		case 0x07:	// ξ
		{
			// ཤ(+4  +40) 
#if 0
			if((skill = pc_checkskill(sd,SW_SWORDMASTERY)) != -1) {
				damage += (skill * 4);
			}
#endif
			break;
		}
		case 0x08:	// ᥤ
		{
			// ᥤ(+3  +30) ᥤ
			if((skill = pc_checkskill(sd,65)) != -1) {
				damage += (skill * 3);
			}
			break;
		}
		case 0x09:	// ʤ?
		case 0x0a:	// 
		case 0x0b:	// 
			break;
		case 0x00:	// Ǽ
		case 0x0c:	// ʥå
		{
			// ĺ(+3  +30) Ǽ,ʥå
#if 0
			if((skill = pc_checkskill(sd,SW_SWORDMASTERY)) != -1) {
				damage += (skill * 3);
			}
#endif
			break;
		}
		case 0x0d:	// ڴ
		{
			// ڴ(+3  +30) ڴ
#if 0
			if((skill = pc_checkskill(sd,SW_SWORDMASTERY)) != -1) {
				damage += (skill * 3);
			}
#endif
			break;
		}
		case 0x0e:	// 
		{
			// ٤(+3  +30) 
#if 0
			if((skill = pc_checkskill(sd,SW_SWORDMASTERY)) != -1) {
				damage += (skill * 3);
			}
#endif
			break;
		}
		case 0x0f:	// 
		{
			// ɥХ󥹥ɥ֥å(+3  +30) 
#if 0
			if((skill = pc_checkskill(sd,SW_SWORDMASTERY)) != -1) {
				damage += (skill * 4);
			}
#endif
			break;
		}
		case 0x10:	// 
		{
			// 뽤(+3  +30) 
			if((skill = pc_checkskill(sd,134)) != -1) {
				//˥å֥̽1դ1/8Ŭ)
				damage += (skill * 3);
			}
			break;
		}
	}
	damage = dmg + damage;
	return (damage);
}

/*==========================================
 * mob򹶷
 *------------------------------------------
 */
int pc_attack_mob(struct map_session_data *sd,struct mob_data *md,unsigned int tick)
{
	int hitrate,hit,damage,type,atkmin,atkmax,div_,damage2;
	int skill,item_id,cri,vitbounsmax;

	// ᡼׻ mob->pcΤȶͭͽ
	hitrate=sd->hit-mob_db[md->class].lv-mob_db[md->class].agi+80;
	// ︦(HIT +2  +20)
	// ɡ̿UP

	if(hitrate<5) hitrate=5;

	hit=rand()%100 < hitrate;

	if(!hit){
		clif_damage(&sd->bl,&md->bl,tick,sd->amotion,mob_db[md->class].dmotion,0,1,0,0);

		return 0;
	}

	type=0;	// normal
	div_ = 1; // single attack

	// ܹϤλ
	// ɡATKý(ȥ󡢥աɥ)
	damage2 = 0;
	damage = (sd->paramc[0]/10) * (sd->paramc[0]/10) + sd->paramc[0] + sd->paramc[4]/5 + sd->paramc[5]/5;
	atkmin = sd->paramc[4];
	if((item_id = pc_checkequip(sd,2)) != -1) {
		if(itemdb_look(item_id) == 11) {
			// ݤξ
			damage = (sd->paramc[4]/10) * (sd->paramc[4]/10) + sd->paramc[4] + sd->paramc[0]/5 + sd->paramc[5]/5;
			// Υ᡼ɲ
//			damage += rand()%ι;
			atkmin = sd->watk * (sd->paramc[4]<sd->watk)?sd->paramc[4]:sd->watk;
		}
	}

	// 
	// ڥ褷Ƥơǹ⤷淿Υ100ˤ(̤)
	// ݥѡե(̤),ɥ쥤C(̤)
	atkmax = (sd->watk * sd->atkmods[mob_db[md->class].size]) / 100;
	if(atkmin > atkmax) atkmin = atkmax;

	cri = 1+(sd->paramc[5] * 30)/10;

	if((item_id = pc_checkequip(sd,34)) != -1) {
		if(itemdb_look(item_id) == 16) {
			// ξ硢ƥܤ
			cri <<= 1;
		}
	}
	cri -= (mob_db[md->class].luk * 30)/10;
	if((rand() % 1000) < cri)
	{
		damage += atkmax;
		type = 0x0a;
	}
	else
	{
		if(atkmax > atkmin)
			damage += atkmin + rand() % (atkmax-atkmin);
		else
			damage += atkmin ;

		// (̤)
		// ︦(ATK +2%  +20%),Сȥ饹(+5%  +25%),¾ϥξ礳
		// Хå,ޥʥ֥쥤,
		// ܡ󥰥Хå,ԥ֡,֥ǥå她ԥ,ԥå,
		// ޡʥ,ȥܥ塼
		// ֥륹ȥ쥤ե,,㡼,
		// ˥å֥

		// оݤɸϤˤ᡼θ
		vitbounsmax = (mob_db[md->class].vit/20)*(mob_db[md->class].vit/20)-1;
		if(vitbounsmax < 1) {
			damage = damage * (100 - mob_db[md->class].def) /100 - (mob_db[md->class].vit);
		} else {
			damage = damage * (100 - mob_db[md->class].def) /100 - (mob_db[md->class].vit+rand()%vitbounsmax);
		}
	}

	// ϣʬ᡼ɲ
	// refine
	// 
	if((item_id = pc_checkequip(sd,2)) != -1) {
		damage += (itemdb_wlv(item_id)*2) - (itemdb_wlv(item_id) == 1)?0:1;
	}

	// 0̤ä1
	if(damage<1) damage=1;

	// ᡼(Τ) ˥å֥̽1դ1/8Ŭ)
	damage = pc_addmastery(sd,md,damage);

	// ɡ᡼UP ξξ纸ΥɤⱦŬ,ϥɤˤϤʤ

	// °Ŭ

	// ΤŬ

	// ꡢ꽤Ŭ
#if 0
	if(1)	// 
	{
		damage2 = damage;
		// 꽤(60%  100%) 
		if((skill = pc_checkskill(sd,132)) != -1) {
			damage = damage * ((50 + (skill * 10))/100);
		}
		// 꽤(40%  80%) 
		if((skill = pc_checkskill(sd,133)) != -1) {
			damage2 = damage2 * ((30 + (skill * 10))/100);
		}
	}
#endif
	item_id = pc_checkequip(sd,34);		// ξѤ
	if(item_id != -1) {
		if(itemdb_look(item_id) == 16) {
			// ɷ᡼
			if((skill = pc_checkskill(sd,49)) != -1) {
				damage2 = damage * (1 + (skill * 2))/100;
			}
			else
			{
				skill = 0;
				damage2 = damage * (1 + (skill * 2))/100;
			}
			if(damage2 < 1) damage2 = 1;
		}
	}

	// ,ûΤ
	item_id = pc_checkequip(sd,2);		// Ѥ?
	if(itemdb_look(item_id) == 0x01) {
		// ֥륢å
#if 1
		if((skill = pc_checkskill(sd,49)) > 0) {
			div_ = (rand()%100 < (skill*10))?2:1;
			if(div_ == 2) damage <<= 1;
			if(div_ > 1) type = 0x08;
		}
#else
			div_ = 2;
			damage *= 2;
			if(div_ > 1) type = 0x08;
			printf("damage : %d [div %d]\n",damage,div_);
#endif
	}
#if 0
	// ֥륹ȥ쥤ե
	if(sd->status.weapon == 0x0b) {
		if((skill = pc_checkskill(sd,AR_DOUBLESTRAFE)) > 0) {
			div_ = 2;
			damage = damage * (3+(skill*0.5));
		}
	}
	// ˥å֥
	if(sd->status.weapon == 0x10) {
		if((skill = pc_checkskill(sd,AS_SONICBLOW)) > 0) {
			div_ = skill;
			damage = damage * (3+(skill*0.5));
		}
	}
#endif


	// ѥåȺ
	clif_damage(&sd->bl,&md->bl,tick,sd->amotion,mob_db[md->class].dmotion,damage,div_,type,damage2);
	mob_damage(sd,md,damage);

	return 0;
}


/*==========================================
 * pc򹶷
 *------------------------------------------
 */
int pc_attack_pc(struct map_session_data *sd,struct map_session_data *tsd,unsigned int tick)
{
	clif_damage(&sd->bl,&sd->bl,tick,sd->amotion,tsd->dmotion,0/*damage sum*/,1/*div*/,0/*type*/,0/*left*/);
	return 0;
}

/*==========================================
 * PCι (timerؿ)
 *------------------------------------------
 */
int pc_attack_timer(int tid,unsigned int tick,int id,int data)
{
	struct map_session_data *sd;
	struct block_list *bl;

	sd=map_id2sd(id);
	if(sd==NULL)
		return 0;
	sd->attacktimer=-1;

	bl=map_id2bl(sd->attacktarget);
	if(bl==NULL)
		return 0;

	// ƱmapǤʤʤ鹶⤷ʤ
	// PCǤƤ⹶⤷ʤ
	if(sd->bl.m != bl->m || pc_isdead(sd))
		return 0;

	if(bl->type==BL_MOB)
		pc_attack_mob(sd,(struct mob_data*)bl,tick);
	else
		pc_attack_pc(sd,(struct map_session_data*)bl,tick);

	sd->attackabletime = tick + sd->aspd*2 ;

	if(sd->state.attack_continue){
		sd->attacktimer=add_timer(sd->attackabletime,pc_attack_timer,sd->bl.id,0);
	}
	return 0;
}

/*==========================================
 * ׵
 * type1ʤ³
 *------------------------------------------
 */
int pc_attack(struct map_session_data *sd,int target_id,int type)
{
	struct block_list *bl;
	int d;

	bl=map_id2bl(target_id);
	if(bl==NULL || (bl->type!=BL_MOB && bl->type!=BL_PC))
		return 1;
	if(sd->attacktimer>0)
		pc_stopattack(sd);
	sd->attacktarget=target_id;
	sd->state.attack_continue=type;

	d=DIFF_TICK(sd->attackabletime,gettick());
	if(d>0 && d<2000){	// delay
		sd->attacktimer=add_timer(sd->attackabletime,pc_attack_timer,sd->bl.id,0);
	} else {
		// timerؿʤΤǰ碌
		pc_attack_timer(-1,gettick(),sd->bl.id,0);
	}
	return 0;
}

/*==========================================
 * ³
 *------------------------------------------
 */
int pc_stopattack(struct map_session_data *sd)
{
	if(sd->attacktimer>0){
		delete_timer(sd->attacktimer,pc_attack_timer);
		sd->attacktimer=-1;
	}
	sd->attacktarget=0;
	sd->state.attack_continue=0;
	return 0;
}

/*==========================================
 * иͼ
 *------------------------------------------
 */
int pc_gainexp(struct map_session_data *sd,int base_exp,int job_exp)
{
	int next;

	sd->status.base_exp += base_exp;
	//printf("base %d/%d ",sd->status.base_exp,pc_nextbaseexp(sd));
	if(sd->status.base_exp >= (next=pc_nextbaseexp(sd))){
		// base¦٥륢å׽
		sd->status.base_exp -= next;

		sd->status.base_level ++;
		clif_updatestatus(sd,SP_BASELEVEL);
		clif_updatestatus(sd,SP_NEXTBASEEXP);
		if(sd->status.base_level>=99)
			sd->status.status_point += 22;
		else
			sd->status.status_point += (sd->status.base_level+14) / 5 ;
		clif_updatestatus(sd,SP_STATUSPOINT);
		pc_calcstatus(sd,0);
		pc_heal(sd,sd->status.max_hp,sd->status.max_sp);

		clif_misceffect(&sd->bl,0);
	}
	clif_updatestatus(sd,SP_BASEEXP);

	//printf("job %d/%d\n",sd->status.job_exp,pc_nextjobexp(sd));
	sd->status.job_exp += job_exp;
	if(sd->status.job_exp >= (next=pc_nextjobexp(sd))){
		// job¦٥륢å׽
		sd->status.job_exp -= next;
		sd->status.job_level ++;
		clif_updatestatus(sd,SP_JOBLEVEL);
		clif_updatestatus(sd,SP_NEXTJOBEXP);
		sd->status.skill_point ++;
		clif_updatestatus(sd,SP_SKILLPOINT);
		pc_calcstatus(sd,0);

		clif_misceffect(&sd->bl,1);
	}
	clif_updatestatus(sd,SP_JOBEXP);

	return 0;
}

/*==========================================
 * base level¦ɬ׷иͷ׻
 *------------------------------------------
 */
int pc_nextbaseexp(struct map_session_data *sd)
{
	if(sd->status.base_level>=100)
		return 999999999;

	return exp_table[0][sd->status.base_level-1];
}

/*==========================================
 * job level¦ɬ׷иͷ׻
 *------------------------------------------
 */
int pc_nextjobexp(struct map_session_data *sd)
{
	int i;

	if(sd->status.job_level>=50)
		return 999999999;

	if(sd->status.class==0) i=1;
	else if(sd->status.class<=6) i=2;
	else i=3;

	return exp_table[i][sd->status.job_level-1];
}

/*==========================================
 * ɬץơݥȷ׻
 *------------------------------------------
 */
int pc_need_status_point(struct map_session_data *sd,int type)
{
	int val;

	if(type<SP_STR || type>SP_LUK)
		return -1;
	val =
		type==SP_STR ? sd->status.str :
		type==SP_AGI ? sd->status.agi :
		type==SP_VIT ? sd->status.vit :
		type==SP_INT ? sd->status.int_:
		type==SP_DEX ? sd->status.dex : sd->status.luk;

	return (val+9)/10+1;
}

/*==========================================
 * ǽĹ
 *------------------------------------------
 */
int pc_statusup(struct map_session_data *sd,int type)
{
	int need,val;

	need=pc_need_status_point(sd,type);
	if(type<SP_STR || type>SP_LUK || need<0 || need>sd->status.status_point){
		clif_statusupack(sd,type,0,0);
		return 1;
	}
	sd->status.status_point-=need;
	switch(type){
	case SP_STR:
		val= ++sd->status.str;
		break;
	case SP_AGI:
		val= ++sd->status.agi;
		break;
	case SP_VIT:
		val= ++sd->status.vit;
		break;
	case SP_INT:
		val= ++sd->status.int_;
		break;
	case SP_DEX:
		val= ++sd->status.dex;
		break;
	case SP_LUK:
		val= ++sd->status.luk;
		break;
	}
	if(need!=pc_need_status_point(sd,type)){
		clif_updatestatus(sd,type-SP_STR+SP_USTR);
	}
	clif_updatestatus(sd,SP_STATUSPOINT);
	clif_updatestatus(sd,type);
	pc_calcstatus(sd,0);
	clif_statusupack(sd,type,1,val);
	return 0;
}

/*==========================================
 * /resetstate
 *------------------------------------------
 */
int pc_resetstate(struct map_session_data* sd)
{
#define sumsp(a) ((a)*((a-2)/10+2) - 5*((a-2)/10)*((a-2)/10) - 6*((a-2)/10) -2)
	int add=0;

	add += sumsp(sd->status.str);
	add += sumsp(sd->status.agi);
	add += sumsp(sd->status.vit);
	add += sumsp(sd->status.int_);
	add += sumsp(sd->status.dex);
	add += sumsp(sd->status.luk);
	sd->status.status_point+=add;

	clif_updatestatus(sd,SP_STATUSPOINT);

	sd->status.str=1;
	sd->status.agi=1;
	sd->status.vit=1;
	sd->status.int_=1;
	sd->status.dex=1;
	sd->status.luk=1;

	clif_updatestatus(sd,SP_STR);
	clif_updatestatus(sd,SP_AGI);
	clif_updatestatus(sd,SP_VIT);
	clif_updatestatus(sd,SP_INT);
	clif_updatestatus(sd,SP_DEX);
	clif_updatestatus(sd,SP_LUK);

	pc_calcstatus(sd,0);

	return 0;
}

/*==========================================
 * /resetskill
 *------------------------------------------
 */
int pc_resetskill(struct map_session_data* sd)
{
	return 0;
}

/*==========================================
 * pc˥᡼Ϳ
 *------------------------------------------
 */
int pc_damage(struct map_session_data *sd,int damage)
{
	// ˻Ǥ̵
	if(pc_isdead(sd))
		return 0;
	// ¤äƤΩ夬
	if(pc_issit(sd))
		pc_setstand(sd);
	// ⤤Ƥ­ߤ
	pc_stop_walking(sd);

	sd->status.hp-=damage;
	if(sd->status.hp>=0){
		// ޤƤʤHPΤ߹
		clif_updatestatus(sd,SP_HP);
		return 0;
	}
	// ˴
	sd->status.hp = 1;
	pc_setdead(sd);
	clif_updatestatus(sd,SP_HP);
	clif_clearchar_area(&sd->bl,1);

	return 0;
}

//
// scriptϢ
//
/*==========================================
 * scriptPCơɤ߽Ф
 *------------------------------------------
 */
int pc_readparam(struct map_session_data *sd,int type)
{
	int val=0;
	switch(type){
	case SP_SKILLPOINT:
		val= sd->status.skill_point;
		break;
	case SP_STATUSPOINT:
		val= sd->status.status_point;
		break;
	case SP_ZENY:
		val= sd->status.zeny;
		break;
	case SP_BASELEVEL:
		val= sd->status.base_level;
		break;
	case SP_JOBLEVEL:
		val= sd->status.job_level;
		break;
	case SP_CLASS:
		val= sd->status.class;
		break;
	case SP_SEX:
		val= sd->sex;
		break;
	}
	return val;
}

/*==========================================
 * scriptPCơ
 *------------------------------------------
 */
int pc_setparam(struct map_session_data *sd,int type,int val)
{
	switch(type){
	case SP_SKILLPOINT:
		sd->status.skill_point = val;
		break;
	case SP_STATUSPOINT:
		sd->status.status_point = val;
		break;
	case SP_ZENY:
		sd->status.zeny = val;
		break;
	}
	clif_updatestatus(sd,type);

	return 0;
}

/*==========================================
 * HP/SP
 *------------------------------------------
 */
int pc_heal(struct map_session_data *sd,int hp,int sp)
{
	printf("heal %d %d\n",hp,sp);
	sd->status.hp+=hp;
	sd->status.sp+=sp;
	if(sd->status.hp>sd->status.max_hp)
		sd->status.hp=sd->status.max_hp;
	if(sd->status.sp>sd->status.max_sp)
		sd->status.sp=sd->status.max_sp;
	if(hp)
		clif_updatestatus(sd,SP_HP);
	if(sp)
		clif_updatestatus(sd,SP_SP);
	return 0;
}

/*==========================================
 * ѹ
 *------------------------------------------
 */
int pc_jobchange(struct map_session_data *sd,int job)
{
	sd->status.class=job;
	clif_changelook(&sd->bl,LOOK_BASE,sd->status.class);

	sd->status.job_level=1;
	sd->status.job_exp=0;
	clif_updatestatus(sd,SP_JOBLEVEL);
	clif_updatestatus(sd,SP_JOBEXP);
	clif_updatestatus(sd,SP_NEXTJOBEXP);
	pc_calcstatus(sd,0);

	return 0;
}

/*==========================================
 * ѹ
 *------------------------------------------
 */
int pc_changelook(struct map_session_data *sd,int type,int val)
{
	switch(type){
	case LOOK_HAIR:
		sd->status.hair=val;
		break;
	case LOOK_WEAPON:
		sd->status.weapon=val;
		break;
	case LOOK_HEAD_BOTTOM:
		sd->status.head_bottom=val;
		break;
	case LOOK_HEAD_TOP:
		sd->status.head_top=val;
		break;
	case LOOK_HEAD_MID:
		sd->status.head_mid=val;
		break;
	case LOOK_HAIR_COLOR:
		sd->status.hair_color=val;
		break;
	case LOOK_CLOTHES_COLOR:
		sd->status.clothes_color=val;
		break;
	case LOOK_SHEILD:
		sd->status.sheild=val;
		break;
	}
	clif_changelook(&sd->bl,type,val);

	return 0;
}

/*==========================================
 * °(,ڥ,)
 *------------------------------------------
 */
int pc_setoption(struct map_session_data *sd,int type)
{
	sd->status.option=type;
	clif_changeoption(sd);

	return 0;
}

/*==========================================
 * scriptѿͤɤ
 *------------------------------------------
 */
int pc_readreg(struct map_session_data *sd,int reg)
{
	int i;

	for(i=0;i<sd->reg_num;i++)
		if(sd->reg[i].index==reg)
			return sd->reg[i].data;
	return 0;
}

/*==========================================
 * scriptѿͤ
 *------------------------------------------
 */
int pc_setreg(struct map_session_data *sd,int reg,int val)
{
	int i;

	for(i=0;i<sd->reg_num;i++)
		if(sd->reg[i].index==reg){
			sd->reg[i].data = val;
			return 0;
		}
	sd->reg_num++;
	sd->reg=realloc(sd->reg,sizeof(sd->reg[0])*sd->reg_num);
	if(sd->reg==NULL){
		printf("out of memory : pc_setreg\n");
		exit(1);
	}
	sd->reg[i].index=reg;
	sd->reg[i].data=val;

	return 0;
	
}

//
// ʪ
//
/*==========================================
 * ƥ
 *------------------------------------------
 */
int pc_equipitem(struct map_session_data *sd,int n,int pos)
{
	int i,nameid;

	nameid=sd->status.inventory[n].nameid;
	//printf("equip %d %x:%x\n",n,itemdb_equippoint(sd,nameid),pos);
	if((itemdb_equippoint(sd,nameid)&pos)==0){
		clif_equipitemack(sd,n,0,0);	// fail
		return 0;
	}
	if(pos==0x88){ // 㳰
		int epor=0;
		for(i=0;i<100;i++){
			if(sd->status.inventory[i].nameid &&
			   sd->status.inventory[i].equip)
				epor |= sd->status.inventory[i].equip;
		}
		epor &= 0x88;
		pos = epor == 0x08 ? 0x80 : 0x08;
	}

	for(i=0;i<100;i++){
		if(sd->status.inventory[i].nameid &&
		   (sd->status.inventory[i].equip&pos)){
			pc_unequipitem(sd,i);
		}
	}
	clif_equipitemack(sd,n,pos,1);
	sd->status.inventory[n].equip=pos;
	pc_calcstatus(sd,0);

	return 0;
}

/*==========================================
 * ʪ򳰤
 *------------------------------------------
 */
int pc_unequipitem(struct map_session_data *sd,int n)
{
	//printf("unequip %d %x:%x\n",n,itemdb_equippoint(sd,sd->status.inventory[n].nameid),sd->status.inventory[n].equip);
	if(sd->status.inventory[n].equip){
		clif_unequipitemack(sd,n,sd->status.inventory[n].equip,1);
		sd->status.inventory[n].equip=0;
	} else {
		clif_unequipitemack(sd,n,0,0);
	}
	pc_calcstatus(sd,0);
	return 0;
}

/*==========================================
 * ƥindexֹͤ᤿
 * ʤǽåԤʤ
 *------------------------------------------
 */
int pc_checkitem(struct map_session_data *sd)
{
	int i,j;

	// ʶͤ
	for(i=j=0;i<MAX_INVENTORY;i++){
		if(sd->status.inventory[i].nameid==0)
			continue;
		if(i>j){
			memcpy(&sd->status.inventory[j],&sd->status.inventory[i],sizeof(struct item));
			sd->status.inventory[i].nameid=0;
		}
		j++;
	}
	// ͤ
	for(i=j=0;i<MAX_CART;i++){
		if(sd->status.cart[i].nameid==0)
			continue;
		if(i>j){
			memcpy(&sd->status.cart[j],&sd->status.cart[i],sizeof(struct item));
			sd->status.cart[i].nameid=0;
		}
		j++;
	}
	// ֥å
	for(i=0;i<MAX_INVENTORY;i++){
		if(sd->status.inventory[i].nameid==0)
			continue;
		if(sd->status.inventory[i].equip & ~itemdb_equippoint(sd,sd->status.inventory[i].nameid))
			sd->status.inventory[i].equip=0;
	}

	return 0;
}

//
// ʪ
//
/*==========================================
 * SP̷׻
 *------------------------------------------
 */
static int pc_spheal(struct map_session_data *sd)
{
	int a;
	a=7500-60*sd->paramc[3];
	if(a<300) a=300;
	if(pc_issit(sd))
		a/=2;
	a=1000*1000/a+1;
	return a;
}

/*==========================================
 * HP̷׻
 *------------------------------------------
 */
static int pc_hpheal(struct map_session_data *sd)
{
	int a;
	a=3000-15*sd->paramc[2]-14*sd->status.base_level;
	if(a<300) a=300;
	if(pc_issit(sd))
		a/=2;
	a=1000*1000/a+1;
	return a;
}

/*==========================================
 * HP/SP  ƥ饤
 *------------------------------------------
 */
static int natural_heal_send_timing;
static int pc_natural_heal_sub(struct map_session_data *sd,va_list ap)
{
	if(sd->weight*2>=sd->max_weight || pc_isdead(sd))
		return 0;

	if(sd->status.sp<sd->status.max_sp)
		sd->sp_sub+=pc_spheal(sd);
	if(sd->walktimer<=0 && sd->status.hp<sd->status.max_hp)
		sd->hp_sub+=pc_hpheal(sd);

	if(natural_heal_send_timing==0){
		if(sd->sp_sub>=4000){
			while(sd->sp_sub>=4000){
				if(sd->status.sp<sd->status.max_sp)
					sd->status.sp++;
				sd->sp_sub-=4000;
			}
			clif_updatestatus(sd,SP_SP);
		}
		if(sd->hp_sub>=4000){
			while(sd->hp_sub>=4000){
				if(sd->status.hp<sd->status.max_hp)
					sd->status.hp++;
				sd->hp_sub-=4000;
			}
			clif_updatestatus(sd,SP_HP);
		}
	}
	return 0;
}

/*==========================================
 * HP/SP (interval timerؿ)
 *------------------------------------------
 */
int pc_natural_heal(int tid,unsigned int tick,int id,int data)
{
	clif_foreachclient(pc_natural_heal_sub);

	natural_heal_send_timing = (natural_heal_send_timing+1) & 3;
	return 0;
}

/*==========================================
 * ֥ݥȤ¸
 *------------------------------------------
 */
int pc_setsavepoint(struct map_session_data *sd,char *mapname,int x,int y)
{
	strncpy(sd->status.save_point.map,mapname,16);
	sd->status.save_point.x = x;
	sd->status.save_point.y = y;
	return 0;
}

/*==========================================
 * ư ƥ饤
 *------------------------------------------
 */
static int last_save_fd,save_flag;
static int pc_autosave_sub(struct map_session_data *sd,va_list ap)
{
	if(save_flag==0 && sd->fd>last_save_fd){
		//printf("autosave %d\n",sd->fd);
		chrif_save(sd);
		save_flag=1;
		last_save_fd = sd->fd;
	}

	return 0;
}

/*==========================================
 * ư (timerؿ)
 *------------------------------------------
 */
int pc_autosave(int tid,unsigned int tick,int id,int data)
{
	save_flag=0;
	clif_foreachclient(pc_autosave_sub);
	if(save_flag==0)
		last_save_fd=0;

	add_timer(gettick()+30*1000/(clif_countusers()+1),pc_autosave,0,0);
	return 0;
}

//
// ʪ
//
/*==========================================
 * եɤ߹
 * exp.txt ɬ׷и
 * job_db1.txt ,hp,sp,®
 * job_db2.txt jobǽͥܡʥ
 * skill_tree.txt ƿΥĥ꡼
 *------------------------------------------
 */
int pc_readdb(void)
{
	int i,j,k;
	FILE *fp;
	char line[1024],*p;

	fp=fopen("db/exp.txt","r");
	if(fp==NULL){
		printf("can't read db/exp.txt\n");
		return 1;
	}
	i=0;
	while(fgets(line,1020,fp)){
		int b,jn,j1,j2;
		if(line[0]=='/' && line[1]=='/')
			continue;
		if(sscanf(line,"%d,%d,%d,%d",&b,&jn,&j1,&j2)!=4)
			continue;
		exp_table[0][i]=b;
		exp_table[1][i]=jn;
		exp_table[2][i]=j1;
		exp_table[3][i]=j2;
		i++;
	}
	fclose(fp);

	fp=fopen("db/job_db1.txt","r");
	if(fp==NULL){
		printf("can't read db/job_db1.txt\n");
		return 1;
	}
	i=0;
	while(fgets(line,1020,fp)){
		char *split[50];
		if(line[0]=='/' && line[1]=='/')
			continue;
		for(j=0,p=line;j<20 && p;j++){
			split[j]=p;
			p=strchr(p,',');
			if(p) *p++=0;
		}
		if(j<20)
			continue;
		max_weight_base[i]=atoi(split[0]);
		hp_coefficient[i]=atoi(split[1]);
		sp_coefficient[i]=atoi(split[2]);
		for(j=0;j<17;j++)
			aspd_base[i][j]=atoi(split[j+3]);
		i++;
		if(i==MAX_PC_CLASS)
			break;
	}
	fclose(fp);

	fp=fopen("db/job_db2.txt","r");
	if(fp==NULL){
		printf("can't read db/job_db2.txt\n");
		return 1;
	}
	i=0;
	while(fgets(line,1020,fp)){
		if(line[0]=='/' && line[1]=='/')
			continue;
		for(j=0,p=line;j<50 && p;j++){
			if(sscanf(p,"%d",&k)==0)
				break;
			job_bonus[i][j]=k;
			p=strchr(p,',');
			if(p) p++;
		}
		i++;
		if(i==MAX_PC_CLASS)
			break;
	}
	fclose(fp);

	memset(skill_tree,sizeof(skill_tree),0);
	fp=fopen("db/skill_tree.txt","r");
	if(fp==NULL){
		printf("can't read db/skill_tree.txt\n");
		return 1;
	}
	while(fgets(line,1020,fp)){
		char *split[50];
		if(line[0]=='/' && line[1]=='/')
			continue;
		for(j=0,p=line;j<13 && p;j++){
			split[j]=p;
			p=strchr(p,',');
			if(p) *p++=0;
		}
		if(j<13)
			continue;
		i=atoi(split[0]);
		for(j=0;skill_tree[i][j].id;j++);
		skill_tree[i][j].id=atoi(split[1]);
		skill_tree[i][j].max=atoi(split[2]);
		for(k=0;k<5;k++){
			skill_tree[i][j].need[k].id=atoi(split[k*2+3]);
			skill_tree[i][j].need[k].lv=atoi(split[k*2+4]);
		}
	}
	fclose(fp);


	return 0;
}

/*==========================================
 * pcط
 *------------------------------------------
 */
int do_init_pc(void)
{
	add_timer_func_list(pc_walk,"pc_walk");
	add_timer_func_list(pc_attack_timer,"pc_attack_timer");
	add_timer_func_list(pc_natural_heal,"pc_natural_heal");
	add_timer_interval(gettick()+10,pc_natural_heal,0,0,250);
	add_timer(gettick()+10,pc_autosave,0,0);
	pc_readdb();

	return 0;
}
