// $Id: pc.h,v 1.12 2003/06/26 05:31:23 lemit Exp $

#ifndef _PC_H_
#define _PC_H_

#include "map.h"

#define pc_setdead(sd) ((sd)->dead_sit = 1)
#define pc_setsit(sd) ((sd)->dead_sit = 2)
#define pc_setstand(sd) ((sd)->dead_sit = 0)
#define pc_isdead(sd) ((sd)->dead_sit == 1)
#define pc_issit(sd) ((sd)->dead_sit == 2)
#define pc_setdir(sd,b,h) ((sd)->dir = (b) ,(sd)->head_dir = (h) )
#define pc_setchatid(sd,n) ((sd)->chatID = n)

int pc_makesavestatus(struct map_session_data *);
int pc_setnewpc(struct map_session_data*,int,int,int,int,int,int);
int pc_authok(int,struct mmo_charstatus *);
int pc_authfail(int);


int pc_walktoxy(struct map_session_data*,int,int);
int pc_stop_walking(struct map_session_data*);
int pc_setpos(struct map_session_data*,char*,int,int,int);
int pc_setsavepoint(struct map_session_data*,char*,int,int);

int pc_checkadditem(struct map_session_data*,int,int);
int pc_inventoryblank(struct map_session_data*);
int pc_payzeny(struct map_session_data*,int);
int pc_additem(struct map_session_data*,struct item*,int);
int pc_getzeny(struct map_session_data*,int);
int pc_delitem(struct map_session_data*,int,int);

int pc_takeitem(struct map_session_data*,struct flooritem_data*);
int pc_dropitem(struct map_session_data*,int,int);

int pc_calcstatus(struct map_session_data*,int);
int pc_bonus(struct map_session_data*,int,int);

int pc_modifybuyvalue(struct map_session_data*,int);
int pc_modifysellvalue(struct map_session_data*,int);

int pc_attack(struct map_session_data*,int,int);
int pc_stopattack(struct map_session_data*);

int pc_gainexp(struct map_session_data*,int,int);
int pc_nextbaseexp(struct map_session_data *);
int pc_nextjobexp(struct map_session_data *);
int pc_need_status_point(struct map_session_data *,int);
int pc_statusup(struct map_session_data*,int);
int pc_resetstate(struct map_session_data*);
int pc_resetskill(struct map_session_data*);
int pc_equipitem(struct map_session_data*,int,int);
int pc_unequipitem(struct map_session_data*,int);
int pc_checkitem(struct map_session_data*);
int pc_useitem(struct map_session_data*,int);

int pc_damage(struct map_session_data*,int);
int pc_heal(struct map_session_data *,int,int);
int pc_jobchange(struct map_session_data *,int);
int pc_setoption(struct map_session_data *,int);
int pc_changelook(struct map_session_data *,int,int);

int pc_readparam(struct map_session_data*,int);
int pc_setparam(struct map_session_data*,int,int);
int pc_readreg(struct map_session_data*,int);
int pc_setreg(struct map_session_data*,int,int);

int do_init_pc(void);

enum {ADDITEM_EXIST,ADDITEM_NEW,ADDITEM_OVERAMOUNT};

#endif
