#ifndef _NULLPO_H_
#define _NULLPO_H_


#define NULLPO_CHECK 1
		// Ŝ̃XCb`錾Ăwb_
		// ɈړĂ


#if __STDC_VERSION__ < 199901L
# if __GNUC__ >= 2
#  define __func__ __FUNCTION__
# else
#  define __func__ ""
# endif
#endif

#define NLP_MARK __FILE__, __LINE__, __func__

/*----------------------------------------------------------------------------
 * Macros
 *----------------------------------------------------------------------------
 */
/*======================================
 * Null`FbN y o͌ return
 *EWJifƂreturnô
 *  sP̂ŎgĂB
 *Enullpo_ret(x = func());
 *  ̂悤Ȏgp@z肵Ă܂B
 *--------------------------------------
 * nullpo_ret(t)
 *   ߂l 0Œ
 * []
 *  t       `FbNΏ
 *--------------------------------------
 * nullpo_retv(t)
 *   ߂l Ȃ
 * []
 *  t       `FbNΏ
 *--------------------------------------
 * nullpo_retr(ret, t)
 *   ߂l w
 * []
 *  ret     return(ret);
 *  t       `FbNΏ
 *--------------------------------------
 * nullpo_ret_f(t, fmt, ...)
 *   ڍ׏o͗p
 *   ߂l 0
 * []
 *  t       `FbNΏ
 *  fmt ... vprintfɓn
 *    l֌Wϐ̏oȂǂ
 *--------------------------------------
 * nullpo_retv_f(t, fmt, ...)
 *   ڍ׏o͗p
 *   ߂l Ȃ
 * []
 *  t       `FbNΏ
 *  fmt ... vprintfɓn
 *    l֌Wϐ̏oȂǂ
 *--------------------------------------
 * nullpo_retr_f(ret, t, fmt, ...)
 *   ڍ׏o͗p
 *   ߂l w
 * []
 *  ret     return(ret);
 *  t       `FbNΏ
 *  fmt ... vprintfɓn
 *    l֌Wϐ̏oȂǂ
 *--------------------------------------
 */

#if NULLPO_CHECK

#define nullpo_ret(t) if (nullpo_chk(NLP_MARK, (void *)(t))) {return(0);}

#define nullpo_retv(t) if (nullpo_chk(NLP_MARK, (void *)(t))) {return;}

#define nullpo_retr(ret, t) if (nullpo_chk(NLP_MARK, (void *)(t))) {return(ret);}


// ψ}NɊւRpC
#if __STDC_VERSION__ >= 199901L
/* C99ɑΉ */
#define nullpo_ret_f(t, fmt, ...) if (nullpo_chk_f(NLP_MARK, (void *)(t), (fmt), __VA_ARGS__)) {return(0);}

#define nullpo_retv_f(t, fmt, ...) if (nullpo_chk_f(NLP_MARK, (void *)(t), (fmt), __VA_ARGS__)) {return;}

#define nullpo_retr_f(ret, t, fmt, ...) if (nullpo_chk_f(NLP_MARK, (void *)(t), (fmt), __VA_ARGS__)) {return(ret);}

#elif __GNUC__ >= 2
/* GCCp */
#define nullpo_ret_f(t, fmt, args...) if (nullpo_chk_f(NLP_MARK, (void *)(t), (fmt), ## args)) {return(0);}

#define nullpo_retv_f(t, fmt, args...) if (nullpo_chk_f(NLP_MARK, (void *)(t), (fmt), ## args)) {return;}

#define nullpo_retr_f(ret, t, fmt, args...) if (nullpo_chk_f(NLP_MARK, (void *)(t), (fmt), ## args)) {return(ret);}

#else

/* ̑̏ꍇEEE orz */

#endif

#else /* NULLPO_CHECK */
/* No Nullpo check */

// if((t)){;}
// ǂ@vȂ̂ŁEEE̍łB
// ꉞ[jO͏oȂ͂

#define nullpo_ret(t) if((t)){;}
#define nullpo_retv(t) if((t)){;}
#define nullpo_retr(ret, t) if((t)){;}

// ψ}NɊւRpC
#if __STDC_VERSION__ >= 199901L
/* C99ɑΉ */
#define nullpo_ret_f(t, fmt, ...) if((t)){;}
#define nullpo_retv_f(t, fmt, ...) if((t)){;}
#define nullpo_retr_f(ret, t, fmt, ...) if((t)){;}

#elif __GNUC__ >= 2
/* GCCp */
#define nullpo_ret_f(t, fmt, args...) if((t)){;}
#define nullpo_retv_f(t, fmt, args...) if((t)){;}
#define nullpo_retr_f(ret, t, fmt, args...) if((t)){;}

#else
/* ̑̏ꍇEEE orz */
#endif

#endif /* NULLPO_CHECK */

/*----------------------------------------------------------------------------
 * Functions
 *----------------------------------------------------------------------------
 */
/*======================================
 * nullpo_chk
 *   Null`FbN y o
 * []
 *  file    __FILE__
 *  line    __LINE__
 *  func    __func__ (֐)
 *    ɂ NLP_MARK gƂ悢
 *  target  `FbNΏ
 * [Ԃl]
 *  0 OK
 *  1 NULL
 *--------------------------------------
 */
int nullpo_chk(const char *file, int line, const char *func, const void *target);


/*======================================
 * nullpo_chk_f
 *   Null`FbN y ڍׂȏo
 * []
 *  file    __FILE__
 *  line    __LINE__
 *  func    __func__ (֐)
 *    ɂ NLP_MARK gƂ悢
 *  target  `FbNΏ
 *  fmt ... vprintfɓn
 *    l֌Wϐ̏oȂǂ
 * [Ԃl]
 *  0 OK
 *  1 NULL
 *--------------------------------------
 */
#if __STDC_VERSION__ >= 199901L
int nullpo_chk_f(const char *file, int line, const char *func, const void *target,
                 const char *fmt, ...)
                 __attribute__((format(printf,5,6)));
#else
int nullpo_chk_f(const char *file, int line, const char *func, const void *target,
                 const char *fmt, ...);
#endif

/*======================================
 * nullpo_info
 *   nullpoo
 * []
 *  file    __FILE__
 *  line    __LINE__
 *  func    __func__ (֐)
 *    ɂ NLP_MARK gƂ悢
 *--------------------------------------
 */
void nullpo_info(const char *file, int line, const char *func);


/*======================================
 * nullpo_info_f
 *   nullpoڍ׏o
 * []
 *  file    __FILE__
 *  line    __LINE__
 *  func    __func__ (֐)
 *    ɂ NLP_MARK gƂ悢
 *  fmt ... vprintfɓn
 *    l֌Wϐ̏oȂǂ
 *--------------------------------------
 */
#if __STDC_VERSION__ >= 199901L
void nullpo_info_f(const char *file, int line, const char *func, 
                   const char *fmt, ...)
                   __attribute__((format(printf,4,5)));
#else
void nullpo_info_f(const char *file, int line, const char *func, 
                   const char *fmt, ...);
#endif

#endif
