// $Id: socket.c,v 1.2 2004/09/15 00:17:17 running_pinata Exp $
// original : core.c 2003/02/26 18:03:12 Rev 1.7

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#ifdef _WIN32
	#include <winsock.h>
	#pragma comment(lib,"ws2_32.lib")
#else
	#include <sys/socket.h>
	#include <sys/select.h>
	#include <netinet/in.h>
	#include <netinet/tcp.h>
	#include <unistd.h>
	#include <sys/time.h>
#endif
#include <fcntl.h>
#include <string.h>

#include "mmo.h"
#include "timer.h"
#include "socket.h"
#include "malloc.h"

// socket.h define ꂽcloseu
#ifdef _WIN32
	#undef close
	#define close(id) do{ if(session[id]) closesocket(session[id]->socket); } while(0);
	#define sock(fd)  (session[fd]->socket)
	int SessionInsertSocket(const SOCKET elem,int pos2);
	int SessionRemoveSocket(const SOCKET elem);
#else
	#undef close
	#define sock(fd)  (fd)
#endif

#ifdef MEMWATCH
#include "memwatch.h"
#endif

fd_set readfds;
int fd_max;

int rfifo_size = 65536;
int wfifo_size = 65536;

struct socket_data *session[FD_SETSIZE];

static int null_parse(int fd);
static int (*default_func_parse)(int) = null_parse;
static int (*default_func_destruct)(int) = NULL;

static int connect_check(unsigned int ip);
/*======================================
 *	CORE : Set function
 *--------------------------------------
 */
void set_defaultparse(int (*defaultparse)(int))
{
	default_func_parse = defaultparse;
}

void set_sock_destruct(int (*func_destruct)(int))
{
	default_func_destruct = func_destruct;
}

/*======================================
 *	CORE : Socket Sub Function
 *--------------------------------------
 */

static int recv_to_fifo(int fd)
{
	int len;

	//printf("recv_to_fifo : %d %d\n",fd,session[fd]->eof);
	if(session[fd]->eof)
		return -1;
	len=recv(sock(fd),session[fd]->rdata+session[fd]->rdata_size,RFIFOSPACE(fd),0);
	//{ int i; printf("recv %d : ",fd); for(i=0;i<len;i++){ printf("%02x ",session[fd]->rdata[session[fd]->rdata_size+i]); } printf("\n");}
	if(len>0){
		session[fd]->rdata_size+=len;
#ifdef _WIN32
	} else if(len == 0 || len == SOCKET_ERROR){
		printf("set eof :%d\n",fd);
		session[fd]->eof=1;
#else
	} else if(len<=0){
		printf("set eof :%d\n",fd);
		session[fd]->eof=1;
#endif
	}
	return 0;
}

static int send_from_fifo(int fd)
{
	int len;

	//printf("send_from_fifo : %d\n",fd);
	if(session[fd]->eof || WFIFOREST(fd) == 0)
		return -1;
	len=send(sock(fd),session[fd]->wdata+session[fd]->wdata_pos,WFIFOREST(fd),0);
	//{ int i; printf("send %d : ",fd);  for(i=0;i<len;i++){ printf("%02x ",session[fd]->wdata[session[fd]->wdata_pos+i]); } printf("\n");}
	if(len>0){
		session[fd]->wdata_pos += len;
		if(session[fd]->wdata_pos == session[fd]->wdata_size) {
			session[fd]->wdata_size = 0;
			session[fd]->wdata_pos  = 0;
		} else if(session[fd]->wdata_pos * 4 > session[fd]->max_wdata) {
			// NAԊu炵Ă݂
			memmove(session[fd]->wdata,session[fd]->wdata+session[fd]->wdata_pos,WFIFOREST(fd));
			session[fd]->wdata_size = WFIFOREST(fd);
			session[fd]->wdata_pos  = 0;
		}
#ifdef _WIN32
	} else if(len == 0 || len == SOCKET_ERROR) {
		printf("set eof :%d\n",fd);
		session[fd]->eof=1;
#else
	} else {
		printf("set eof :%d\n",fd);
		session[fd]->eof=1;
#endif
	}
	return 0;
}

static int null_parse(int fd)
{
	printf("null_parse : %d\n",fd);
	RFIFOSKIP(fd,RFIFOREST(fd));
	return 0;
}

/*======================================
 *	CORE : Socket Function
 *--------------------------------------
 */

static int connect_client(int listen_fd)
{
	int fd;
	struct sockaddr_in client_address;
	int len;
	int result;
	int yes = 1; // reuse fix
#ifdef _WIN32
	SOCKET socket;
#endif
	//printf("connect_client : %d\n",listen_fd);

	len=sizeof(client_address);

#ifdef _WIN32
	result = 1;
	fd=accept(session[listen_fd]->socket,(struct sockaddr*)&client_address,&len);
	ioctlsocket(fd,FIONBIO,&result);
#else
	fd=accept(listen_fd,(struct sockaddr*)&client_address,&len);
	result = fcntl(fd,F_SETFL,O_NONBLOCK);
#endif

//	setsockopt(fd,SOL_SOCKET,SO_REUSEADDR,NULL,0);
	setsockopt(fd,SOL_SOCKET,SO_REUSEADDR,(char *)&yes,sizeof yes); // reuse fix
#ifdef SO_REUSEPORT
//	setsockopt(fd,SOL_SOCKET,SO_REUSEPORT,NULL,0);
	setsockopt(fd,SOL_SOCKET,SO_REUSEPORT,(char *)&yes,sizeof yes); //reuse fix
#endif
//	setsockopt(fd,IPPROTO_TCP,TCP_NODELAY,NULL,0);
	setsockopt(fd,IPPROTO_TCP,TCP_NODELAY,(char *)&yes,sizeof yes); // reuse fix

	if(fd==-1){
		printf("accept");
		return -1;
	} else if(!connect_check(*(unsigned int*)(&client_address.sin_addr))) {
#ifdef _WIN32
		closesocket(fd);
#else
		close(fd);
#endif
		return -1;
	} else {
		FD_SET(fd,&readfds);
	}
#ifdef _WIN32
	result = 1;
	ioctlsocket(fd,FIONBIO,&result);

	socket = fd;
	fd=2;
	while(session[fd] != NULL && fd<fd_max) {
		fd++;
	}
	SessionInsertSocket(socket,fd);
#else
	result = fcntl(fd, F_SETFL, O_NONBLOCK);
#endif

	session[fd] = (struct socket_data *)aCalloc(1,sizeof(*session[fd]));
	session[fd]->rdata       = (unsigned char *)aCalloc(1,rfifo_size);
	session[fd]->wdata       = (unsigned char *)aCalloc(1,wfifo_size);
	session[fd]->max_rdata   = rfifo_size;
	session[fd]->max_wdata   = wfifo_size;
	session[fd]->func_recv   = recv_to_fifo;
	session[fd]->func_send   = send_from_fifo;
	session[fd]->func_parse  = default_func_parse;
	session[fd]->client_addr = client_address;
#if _WIN32
	session[fd]->socket      = socket;
#endif
	session[fd]->func_destruct = default_func_destruct;
	if(fd_max<=fd) fd_max=fd+1;

  //printf("new_session : %d %d\n",fd,session[fd]->eof);
  return fd;
}

int make_listen_port(int port)
{
	struct sockaddr_in server_address;
	int fd;
	int result;
	int yes = 1; // reuse fix
#ifdef _WIN32
	SOCKET sock;
#endif

	fd = socket( AF_INET, SOCK_STREAM, 0 );
#ifdef _WIN32
	result = 1;
	ioctlsocket(fd,FIONBIO,&result);
#else
	result = fcntl(fd,F_SETFL,O_NONBLOCK);
#endif

#ifndef _WIN32
//	setsockopt(fd,SOL_SOCKET,SO_REUSEADDR,NULL,0);
	setsockopt(fd,SOL_SOCKET,SO_REUSEADDR,(char *)&yes,sizeof yes); // reuse fix
#ifdef SO_REUSEPORT
//	setsockopt(fd,SOL_SOCKET,SO_REUSEPORT,NULL,0);
	setsockopt(fd,SOL_SOCKET,SO_REUSEPORT,(char *)&yes,sizeof yes); //reuse fix
#endif
//	setsockopt(fd,IPPROTO_TCP,TCP_NODELAY,NULL,0);
	setsockopt(fd,IPPROTO_TCP,TCP_NODELAY,(char *)&yes,sizeof yes); // reuse fix
#endif

	server_address.sin_family      = AF_INET;
	server_address.sin_addr.s_addr = htonl( INADDR_ANY );
	server_address.sin_port        = htons((unsigned short)port);

	result = bind(fd, (struct sockaddr*)&server_address, sizeof(server_address));
	if( result == -1 ) {
		perror("bind");
		exit(1);
	}
	result = listen( fd, 5 );
	if( result == -1 ) { /* error */
		perror("listen");
		exit(1);
	}

	FD_SET(fd, &readfds );

#ifdef _WIN32
	sock = fd;
	fd=2;
	while(session[fd] != NULL && fd<fd_max) {
		fd++;
	}
	SessionInsertSocket(sock,fd);
#endif

	session[fd] = (struct socket_data *)aCalloc(1,sizeof(*session[fd]));
	session[fd]->func_recv = connect_client;
#ifdef _WIN32
	session[fd]->socket = sock;
#endif
	if(fd_max<=fd) fd_max=fd+1;

	return fd;
}

int make_connection(long ip,int port)
{
	struct sockaddr_in server_address;
	int fd;
	int result;
	int yes = 1; // reuse fix
#ifdef _WIN32
	SOCKET sock;
#endif

	fd = socket( AF_INET, SOCK_STREAM, 0 );

	//	setsockopt(fd,SOL_SOCKET,SO_REUSEADDR,NULL,0);
	setsockopt(fd,SOL_SOCKET,SO_REUSEADDR,(char *)&yes,sizeof yes); // reuse fix
#ifdef SO_REUSEPORT
//	setsockopt(fd,SOL_SOCKET,SO_REUSEPORT,NULL,0);
	setsockopt(fd,SOL_SOCKET,SO_REUSEPORT,(char *)&yes,sizeof yes); //reuse fix
#endif
//	setsockopt(fd,IPPROTO_TCP,TCP_NODELAY,NULL,0);
	setsockopt(fd,IPPROTO_TCP,TCP_NODELAY,(char *)&yes,sizeof yes); // reuse fix

	server_address.sin_family = AF_INET;
	server_address.sin_addr.s_addr = ip;
	server_address.sin_port = htons((unsigned short)port);

	result = connect(fd, (struct sockaddr *)(&server_address),sizeof(struct sockaddr_in));
	if(result != 0) {
		// ڑs
		printf("make_connection : connection failed. %08x:%d\n",(int)ip,port);
		close(fd);
		return 0;
	}

	// connect ̑OɃmubN[hݒ肷ƁA
	// connect ̌ʂOɏAĂ
#ifdef _WIN32
	result = 1;
	ioctlsocket(fd,FIONBIO,&result);
#else
	result = fcntl(fd, F_SETFL, O_NONBLOCK);
#endif
	
	FD_SET(fd,&readfds);

#ifdef _WIN32
	sock = fd;
	fd=2;
	while(session[fd] != NULL && fd<fd_max) {
		fd++;
	}
	SessionInsertSocket(sock,fd);
#endif

	session[fd] = (struct socket_data *)aCalloc(1,sizeof(*session[fd]));

	session[fd]->rdata      = (unsigned char *)aCalloc(1,rfifo_size);
	session[fd]->wdata      = (unsigned char *)aCalloc(1,wfifo_size);
	session[fd]->max_rdata  = rfifo_size;
	session[fd]->max_wdata  = wfifo_size;
	session[fd]->func_recv  = recv_to_fifo;
	session[fd]->func_send  = send_from_fifo;
	session[fd]->func_parse = default_func_parse;
#if _WIN32
	session[fd]->socket = sock;
#endif
	session[fd]->func_destruct = default_func_destruct;
	if(fd_max<=fd) fd_max=fd+1;

	return fd;
}

int delete_session(int fd)
{
	if(fd<=0 || fd>=FD_SETSIZE)
		return -1;
	if(session[fd]){
		// QdĂяo̖h~
		if(session[fd]->flag_destruct) {
			return 0;
		}
		session[fd]->flag_destruct = 1;
		// fXgN^Ăяo
		if(session[fd]->func_destruct) {
			session[fd]->func_destruct(fd);
		}
		close(fd);
		FD_CLR(sock(fd),&readfds);
		#ifdef _WIN32
			SessionRemoveSocket(sock(fd));
		#endif
		if(session[fd]->rdata)
			free(session[fd]->rdata);
		if(session[fd]->wdata)
			free(session[fd]->wdata);
		if(session[fd]->session_data)
			free(session[fd]->session_data);
		free(session[fd]);
	}
	session[fd]=NULL;
	//printf("delete_session:%d\n",fd);
	return 0;
}

int realloc_fifo(int fd,int rfifo_size,int wfifo_size)
{
	struct socket_data *s;
	if( fd <= 0) return 0;
	s = session[fd];
	if( s->max_rdata != rfifo_size && s->rdata_size < rfifo_size){
	
		s->rdata      = (unsigned char *)aRealloc(s->rdata, rfifo_size);
		s->max_rdata  = rfifo_size;
	}
	if( s->max_wdata != wfifo_size && s->wdata_size < wfifo_size){
		s->wdata      = (unsigned char *)aRealloc(s->wdata, wfifo_size);
		s->max_wdata  = wfifo_size;
	}
	return 0;
}

int WFIFOSET(int fd,int len)
{
	struct socket_data *s;
	if(fd <= 0) return 0; 
	s = session[fd];
	if( s->wdata_size+len+16384 > s->max_wdata ){
		realloc_fifo(fd,s->max_rdata, s->max_wdata <<1 );
		printf("socket: %d wdata expanded to %d bytes.\n",fd, s->max_wdata);
	}
	s->wdata_size=(s->wdata_size+(len)+2048 < s->max_wdata) ?
		 s->wdata_size+len : (printf("socket: %d wdata lost !!\n",fd),s->wdata_size);
	return 0;
}

#ifdef _WIN32

// the windows fd_set structures are simple
// typedef struct fd_set {
//        u_int fd_count;               /* how many are SET? */
//        SOCKET  fd_array[FD_SETSIZE];   /* an array of SOCKETs */
// } fd_set;
//
// the select sets the correct fd_count and the array
// so just access the signaled sockets one by one

// this could be realized also with an additional element in the session data
// or an array with "struct {socket_data*, SOCKET}[]"
// anyway it is working that way better because of less changes
// otherwise it might be necessary to change access from extern structs
// and it might be a bit slower to access then

struct {
	SOCKET sock;	// array of corrosponding sockets
	int    pos;
} sessionsockets[FD_SETSIZE];
int sessioncount;

///////////////////////////////////////////////////////////////////////////////
// binary search implementation
// might be not that efficient in this implementation
// it first checks the boundaries so calls outside
// the list range are handles much faster
// at the expence of some extra code
// runtime behaviour much faster if often called for outside data
///////////////////////////////////////////////////////////////////////////////
int SessionFindSocket(const SOCKET elem, size_t *retpos)
{	// do a binary search with smallest first
	// make some initial stuff
	int ret = 0;
	size_t a=0, b=sessioncount-1, c;
	size_t pos = 0;

	// just to be sure we have to do something
	if( sessioncount==0 )
	{	ret = 0;
	}
	else if( elem < sessionsockets[a].sock )
	{	// less than lower
		pos = a;
		ret = 0;
	}
	else if( elem > sessionsockets[b].sock )
	{	// larger than upper
		pos = b + 1;
		ret = 0;
	}
	else if( elem == sessionsockets[a].sock )
	{	// found at first position
		pos = a;
		ret = 1;
	}
	else if( elem == sessionsockets[b].sock )
	{	// found at last position
		pos = b;
		ret = 1;
	}
	else
	{	// binary search
		// search between first and last
		do
		{
			c=(a+b)/2;
			if( elem == sessionsockets[c].sock )
			{	// found it
				b=c;
				ret = 1;
				break;
			}
			else if( elem < sessionsockets[c].sock )
				b=c;
			else
				a=c;
		}while( (a+1) < b );
		pos = b;
		// return the next larger element to the given
		// or the found element so we can insert a new element there
	}
	// just to make sure we call this with a valid pointer,
	// on c++ it would be a reference and you could omitt the NULL check
	if(retpos) *retpos = pos;
	return ret;
}

int SessionInsertSocket(const SOCKET elem,int pos2)
{
	size_t pos;
	if(sessioncount<FD_SETSIZE) // max number of allowed sockets
	if( !SessionFindSocket(elem, &pos) )
	{
		if((size_t)sessioncount!=pos)
		{	// shift up one position
			memmove( sessionsockets+pos+1, sessionsockets+pos,(sessioncount-pos)*sizeof(sessionsockets[0]));
		}
		sessionsockets[pos].sock = elem;
		sessionsockets[pos].pos  = pos2;
		sessioncount++;
		return pos;
	}
	// otherwise the socket is already in the list
	return -1;
}

int SessionRemoveSocket(const SOCKET elem)
{
	size_t pos;
	if( SessionFindSocket(elem, &pos) )
	{	// shift down one position
		// and just overwrite the pointers here,
		// so clear the session pointer before calling this
		memmove( sessionsockets+pos, sessionsockets+pos+1,(sessioncount-pos-1)*sizeof(sessionsockets[0]));
		sessioncount--;
		return 1;
	}
	// otherwise the socket is not in the list
	return 0;
}

void process_fdset(fd_set* rfd, fd_set* wfd) {
	size_t i;
	size_t fd;
	for(i=0;i<rfd->fd_count;i++)
	{
		if( SessionFindSocket( rfd->fd_array[i], &fd ) ) {
			fd = sessionsockets[fd].pos;
			if( session[fd] && (session[fd]->func_recv) ) {
				session[fd]->func_recv(fd);
			}
		}
	}
	for(i=0;i<wfd->fd_count;i++)
	{
		if( SessionFindSocket( wfd->fd_array[i], &fd ) ) {
			fd = sessionsockets[fd].pos;
			if( session[fd] && (session[fd]->func_send) ) {
				session[fd]->func_send(fd);
			}
		}
	}
}

#else /* _WIN32 */

// some unix, might work on darwin as well

// unix uses a bit array where the socket number equals the
// position in the array, so finding sockets inside that array
// is not that easy exept the socket is knows before
// so this method here goes through the bit array
// and build the socket number from the position
// where a set bit was found.
// since we can skip 32 sockets all together when none is set
// we can travel quite fast through the array

#ifndef howmany
	#define howmany(x,y) (((x)+((y)-1))/(y)) 
#endif

// Find the log base 2 of an N-bit integer in O(lg(N)) operations
// in this case for 32bit input it would be 11 operations

inline unsigned long log2(unsigned long v)
{
	register unsigned long c = 0;
	if (v & 0xFFFF0000) { v >>= 0x10; c |= 0x10; }
	if (v & 0x0000FF00) { v >>= 0x08; c |= 0x08; }
	if (v & 0x000000F0) { v >>= 0x04; c |= 0x04; }
	if (v & 0x0000000C) { v >>= 0x02; c |= 0x02; }
	if (v & 0x00000002) { v >>= 0x01; c |= 0x01; }
	return c;
}

void process_fdset(fd_set* rfd, fd_set* wfd) {
	unsigned int	sock;
	unsigned long	val;
	unsigned long	bits;
	unsigned long	nfd=0;
	// usually go up to 'howmany(FD_SETSIZE, NFDBITS)'
	unsigned long	max = howmany(fd_max, NFDBITS);
	
	while( nfd <  max )
	{	// while something is set in the ulong at position nfd
		bits = rfd->fds_bits[nfd];
//		val = 0;
		while( bits )
		{	// calc the highest bit with log2
			// and clear it from the field
			// this method is especially fast
			// when only a few bits are set in the field
			// which usually happens on read events
			val = log2( bits );
			bits ^= (1<<val);	
			// build the socket number
			sock = nfd*NFDBITS + val;

			///////////////////////////////////////////////////
			// call the user function
			if( session[sock] && session[sock]->func_recv )
				session[sock]->func_recv(sock);
		}
		// go to next field position
		nfd++;
	}

	// vars are declared above already
	nfd=0;
	while( nfd < max  )
	{	// while something is set in the ulong at position nfd
		bits = wfd->fds_bits[nfd];
//		val = 0;
		while( bits )
		{	// calc the highest bit with log2
			// and clear it from the field
			// this method is especially fast
			// when only a few bits are set in the field
			// which usually happens on read events
			val = log2( bits );
			bits ^= (1<<val);	
			// build the socket number
			sock = nfd*NFDBITS + val;

			///////////////////////////////////////////////////
			// call the user function
			if( session[sock] && (session[sock]->func_send) )
				session[sock]->func_send(sock);
		}
		// go to next field position
		nfd++;
	}
}

#endif /* _WIN32 */

int do_sendrecv(int next)
{
	fd_set rfd,wfd;
	struct timeval timeout;
	int ret,i;

	memcpy(&rfd,&readfds,sizeof(fd_set));
	FD_ZERO(&wfd);
	for(i=0;i<fd_max;i++){
		if(!session[i])
			continue;
		if(session[i]->wdata_size)
			FD_SET(sock(i),&wfd);
	}
	timeout.tv_sec  = next/1000;
	timeout.tv_usec = next%1000*1000;
	ret = select(fd_max,&rfd,&wfd,NULL,&timeout);
	if(ret<=0) {
		return 0;
	}
	process_fdset(&rfd,&wfd);
	return 0;
}

int do_parsepacket(void)
{
	int i;
	for(i=0;i<fd_max;i++){
		if(!session[i])
			continue;
		if(session[i]->eof) {
			delete_session(i);
		} else {
			if(session[i]->func_parse && session[i]->rdata_size != session[i]->rdata_pos)
				session[i]->func_parse(i);
			// NAԊu炵Ă݂
			if(session[i]->rdata_pos * 4 > session[i]->max_rdata) {
				memmove(session[i]->rdata,RFIFOP(i,0),RFIFOREST(i));
				session[i]->rdata_size = RFIFOREST(i);
				session[i]->rdata_pos  = 0;
			}
		}
	}
	return 0;
}

int parsepacket_timer(int tid, unsigned int tick, int id, int data) {
	do_parsepacket();
	return 0;
}
/* DDoS U΍ */

enum {
	ACO_DENY_ALLOW=0,
	ACO_ALLOW_DENY,
	ACO_MUTUAL_FAILTURE,
};

struct _access_control {
	unsigned int ip;
	unsigned int mask;
};

static struct _access_control *access_allow;
static struct _access_control *access_deny;
static int access_order=ACO_DENY_ALLOW;
static int access_allownum=0;
static int access_denynum=0;
static int access_debug;
static int ddos_count     = 10;
static int ddos_interval  = 3000;
static int ddos_autoreset = 600*1000;

struct _connect_history {
	struct _connect_history *next;
	struct _connect_history *prev;
	int    status;
	int    count;
	unsigned int ip;
	unsigned int tick;
};
static struct _connect_history *connect_history[0x10000];
static int connect_check_(unsigned int ip);

// ڑł邩ǂ̊mF
//   false : ڑOK
//   true  : ڑNG
static int connect_check(unsigned int ip) {
	int result = connect_check_(ip);
	if(access_debug) {
		printf("connect_check: connection from %08x %s\n",
			ip,result ? "allowed" : "denied");
	}
	return result;
}
	
static int connect_check_(unsigned int ip) {
	struct _connect_history *hist     = connect_history[ip & 0xFFFF];
	struct _connect_history *hist_new;
	int    i,is_allowip = 0,is_denyip = 0,connect_ok = 0;

	// allow , deny XgɓĂ邩mF
	for(i = 0;i < access_allownum; i++) {
		if((ip & access_allow[i].mask) == (access_allow[i].ip & access_allow[i].mask)) {
			if(access_debug) {
				printf("connect_check: match allow list from:%08x ip:%08x mask:%08x\n",
					ip,access_allow[i].ip,access_allow[i].mask);
			}
			is_allowip = 1;
			break;
		}
	}
	for(i = 0;i < access_denynum; i++) {
		if((ip & access_deny[i].mask) == (access_deny[i].ip & access_deny[i].mask)) {
			if(access_debug) {
				printf("connect_check: match deny list  from:%08x ip:%08x mask:%08x\n",
					ip,access_deny[i].ip,access_deny[i].mask);
			}
			is_denyip = 1;
			break;
		}
	}
	// RlNgo邩ǂmF
	// connect_ok
	//   0 : ɋ
	//   1 : cC`FbŇʎ
	//   2 : ɋ
	switch(access_order) {
	case ACO_DENY_ALLOW:
	default:
		if(is_allowip) {
			connect_ok = 2;
		} else if(is_denyip) {
			connect_ok = 0;
		} else {
			connect_ok = 1;
		}
		break;
	case ACO_ALLOW_DENY:
		if(is_denyip) {
			connect_ok = 0;
		} else if(is_allowip) {
			connect_ok = 2;
		} else {
			connect_ok = 1;
		}
		break;
	case ACO_MUTUAL_FAILTURE:
		if(is_allowip) {
			connect_ok = 2;
		} else {
			connect_ok = 0;
		}
		break;
	}

	// ڑ𒲂ׂ
	while(hist) {
		if(ip == hist->ip) {
			// IP
			if(hist->status) {
				// ban tOĂ
				return (connect_ok == 2 ? 1 : 0);
			} else if(DIFF_TICK(gettick(),hist->tick) < ddos_interval) {
				// ddos_intervalbȓɃNGXgL
				hist->tick = gettick();
				if(hist->count++ >= ddos_count) {
					// ddos Uo
					hist->status = 1;
					printf("connect_check: ddos attack detected (%d.%d.%d.%d)\n",
						ip & 0xFF,(ip >> 8) & 0xFF,(ip >> 16) & 0xFF,ip >> 24);
					return (connect_ok == 2 ? 1 : 0);
				} else {
					return connect_ok;
				}
			} else {
				// ddos_intervalbȓɃNGXĝŃ^C}[NA
				hist->tick  = gettick();
				hist->count = 0;
				return connect_ok;
			}
		}
		hist = hist->next;
	}
	// IPXgɖ̂ŐVK쐬
	hist_new = calloc(1,sizeof(struct _connect_history));
	hist_new->ip   = ip;
	hist_new->tick = gettick();
	if(connect_history[ip & 0xFFFF] != NULL) {
		hist = connect_history[ip & 0xFFFF];
		hist->prev = hist_new;
		hist_new->next = hist;
	}
	connect_history[ip & 0xFFFF] = hist_new;
	return connect_ok;
}

static int connect_check_clear(int tid,unsigned int tick,int id,int data) {
	int i;
	int clear = 0;
	int list  = 0;
	struct _connect_history *hist , *hist2;
	for(i = 0;i < 0x10000 ; i++) {
		hist = connect_history[i];
		while(hist) {
			if(
				(DIFF_TICK(tick,hist->tick) > ddos_interval * 3 && !hist->status) ||
				(DIFF_TICK(tick,hist->tick) > ddos_autoreset && hist->status)
			) {
				// clear data
				hist2 = hist->next;
				if(hist->prev) {
					hist->prev->next = hist->next;
				} else {
					connect_history[i] = hist->next;
				}
				if(hist->next) {
					hist->next->prev = hist->prev;
				}
				free(hist);
				hist = hist2;
				clear++;
			} else {
				hist = hist->next;
				list++;
			}
		}
	}
	if(access_debug) {
		printf("connect_check_clear: clear = %d list = %d\n",clear,list);
	}
	return list;
}

// IP}XN`FbN
int access_ipmask(const char *str,struct _access_control* acc)
{
	unsigned int mask=0,i=0,m,ip, a0,a1,a2,a3;
	if( !strcmp(str,"all") ) {
		ip   = 0;
		mask = 0;
	} else {
		if( sscanf(str,"%d.%d.%d.%d%n",&a0,&a1,&a2,&a3,&i)!=4 || i==0) {
			printf("access_ipmask: unknown format %s\n",str);
			return 0;
		}
		ip = (a3 << 24) | (a2 << 16) | (a1 << 8) | a0;

		if(sscanf(str+i,"/%d.%d.%d.%d",&a0,&a1,&a2,&a3)==4 ){
			mask = (a3 << 24) | (a2 << 16) | (a1 << 8) | a0;
		} else if(sscanf(str+i,"/%d",&m) == 1) {
			for(i=0;i<m;i++) {
				mask = (mask >> 1) | 0x80000000;
			}
			mask = ntohl(mask);
		} else {
			mask = 0xFFFFFFFF;
		}
	}
	if(access_debug) {
		printf("access_ipmask: ip:%08x mask:%08x %s\n",ip,mask,str);
	}
	acc->ip   = ip;
	acc->mask = mask;
	return 1;
}

int socket_config_read(void) {
	int i;
	char line[1024],w1[1024],w2[1024];
	FILE *fp;

	fp=fopen("conf/socket.conf","r");
	if(fp==NULL){
		printf("file not found: %s\n","conf/socket.conf");
		return 1;
	}
	while(fgets(line,1020,fp)){
		if(line[0] == '/' && line[1] == '/')
			continue;

		i=sscanf(line,"%[^:]: %[^\r\n]",w1,w2);
		if(i!=2)
			continue;

		if(strcmpi(w1,"order")==0){
			access_order=atoi(w2);
			if(strcmpi(w2,"deny,allow")==0) access_order=ACO_DENY_ALLOW;
			if(strcmpi(w2,"allow,deny")==0) access_order=ACO_ALLOW_DENY;
			if(strcmpi(w2,"mutual-failture")==0) access_order=ACO_MUTUAL_FAILTURE;
		} else if(strcmpi(w1,"allow")==0){
			access_allow = aRealloc(access_allow,(access_allownum+1)*sizeof(struct _access_control));
			if(access_ipmask(w2,&access_allow[access_allownum])) {
				access_allownum++;
			}
		} else if(strcmpi(w1,"deny")==0){
			access_deny = aRealloc(access_deny,(access_denynum+1)*sizeof(struct _access_control));
			if(access_ipmask(w2,&access_deny[access_denynum])) {
				access_denynum++;
			}
		} else if(!strcmpi(w1,"ddos_interval")){
			ddos_interval = atoi(w2);
		} else if(!strcmpi(w1,"ddos_count")){
			ddos_count = atoi(w2);
		} else if(!strcmpi(w1,"ddos_autoreset")){
			ddos_autoreset = atoi(w2);
		} else if(!strcmpi(w1,"debug")){
			access_debug = atoi(w2);
		} else {
			printf("socket_config_read: unknown config: %s",line);
		}
	}
	fclose(fp);
	return 0;
}

void do_final_socket(void) {
	int i;
	struct _connect_history *hist , *hist2;
	for(i = 0;i < fd_max; i++) {
		if(session[i]) {
			delete_session(i);
		}
	}
	for(i = 0;i < 0x10000 ; i++) {
		hist = connect_history[i];
		while(hist) {
			hist2 = hist->next;
			free(hist);
			hist = hist2;
		}
	}
	free(access_allow);
	free(access_deny);

	// session[0] ̃_~[f[^폜
	free(session[0]->rdata);
	free(session[0]->wdata);
	free(session[0]);
}

void do_socket(void)
{
	FD_ZERO(&readfds);
#ifdef _WIN32
	{
		WSADATA  Data;
		if(WSAStartup(MAKEWORD(1,1),&Data) != 0) {
			MessageBox(NULL,"Winsock Dll Load Error","socket.c",MB_OK);
			exit(1);
		}
	}
#endif
	atexit(do_final_socket);
	socket_config_read();

	// session[0] Ƀ_~[f[^mۂ
	session[0] = (struct socket_data *)aCalloc(1,sizeof(*session[0]));
	session[0]->rdata       = (unsigned char *)aCalloc(1,rfifo_size);
	session[0]->wdata       = (unsigned char *)aCalloc(1,wfifo_size);
	session[0]->max_rdata   = rfifo_size;
	session[0]->max_wdata   = wfifo_size;

	// Ƃ肠TƂɕsvȃf[^폜
	add_timer_interval(gettick()+1000,connect_check_clear,0,0,300*1000);
}
